/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.common.client;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.TestFailureException;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.validation.ValidationFactory;
import com.sun.ts.tests.common.webclient.validation.ValidationStrategy;
import com.sun.ts.tests.jaxrs.common.client.ApacheRequestAdapter;
import com.sun.ts.tests.jaxrs.common.client.ApacheResponseAdapter;
import com.sun.ts.tests.jaxrs.common.client.JdkLoggingFilter;
import com.sun.ts.tests.jaxrs.common.client.TextCaser;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class JaxrsWebTestCase
extends WebTestCase {
    protected Request request;
    protected Response response;
    protected String requestType;
    protected String urlRequest;
    protected Object entity;
    protected int port;
    protected String hostname;
    protected Map<String, String> headerMap;
    protected HttpResponse _response;
    protected boolean printEntity = true;
    protected boolean bufferEntity = false;
    protected Object loggingFilter;
    protected List<Object> providersToRegister;
    protected ValidationStrategy strategy = null;
    protected boolean printClientCall = false;
    protected TextCaser textCaser = TextCaser.NONE;
    protected Runnable asyncRunnable;
    protected Execution executionType = Execution.SYNCHRONOUS;
    protected Client client;

    public JaxrsWebTestCase() {
        this.strategy = ValidationFactory.getInstance((String)"com.sun.ts.tests.common.webclient.validation.TokenizedValidator");
        this.headerMap = new HashMap<String, String>();
        this.providersToRegister = new LinkedList<Object>();
        this.closeClient();
    }

    public void setStrategy(String validator) {
        ValidationStrategy strat = ValidationFactory.getInstance((String)validator);
        if (strat != null) {
            this.strategy = strat;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("[WebTestCase][WARNING] An attempt was made to use a ");
            sb.append("non-existing validator (");
            sb.append(validator);
            sb.append(").  Falling back to the TokenizedValidator");
            TestUtil.logMsg((String)sb.toString());
        }
    }

    public void execute() throws TestFailureException {
        this.verifyValidationStrategy();
        this.verifySettings();
        try {
            String url = this.logClientRequestAndGetUrl();
            this.client = this.getClientWithRegisteredProviders();
            WebTarget target = this.client.target(url.toString());
            Invocation i = this.buildRequest(target);
            this.response = this.invoke(i);
            if (this.bufferEntity) {
                this.response.bufferEntity();
            }
        }
        catch (Throwable t) {
            String message = t.getMessage();
            StringBuilder sb = new StringBuilder();
            sb.append("[FATAL] Unexpected failure during test execution.\n");
            sb.append(this.printClientCall().toString());
            sb.append(message == null ? t.toString() : message);
            throw new TestFailureException(sb.toString(), t);
        }
        if (!this.strategy.validate((WebTestCase)this)) {
            throw new TestFailureException("Test FAILED!");
        }
    }

    public void closeClient() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
    }

    protected void verifyValidationStrategy() {
        try {
            this.getStrategy();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("[FATAL] No Validator available.");
        }
    }

    protected void verifySettings() throws TestFailureException {
        if (this.hostname == null) {
            throw new TestFailureException("No hostname set");
        }
        if (this.port == 0) {
            throw new TestFailureException("Port not set");
        }
        if (this.requestType == null) {
            throw new TestFailureException("No request method set");
        }
        if (this.urlRequest == null) {
            throw new TestFailureException("No resource url request set");
        }
    }

    protected Client getClientWithRegisteredProviders() {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(this.isPrintedEntity()));
        for (Object o : this.providersToRegister) {
            if (o instanceof Class) {
                client.register((Class)o);
                continue;
            }
            client.register(o);
        }
        return client;
    }

    protected String logClientRequestAndGetUrl() {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this.hostname).append(":").append(this.port);
        url.append(this.urlRequest);
        StringBuilder msg = new StringBuilder();
        msg.append("[Request] Dispatching request: '").append(this.requestType).append(" ").append((CharSequence)url).append("' to target server at '").append(this.hostname).append(":").append(this.port).append("'");
        TestUtil.logMsg((String)msg.toString());
        TestUtil.logMsg((String)"###############################");
        if (this.printClientCall) {
            TestUtil.logMsg((String)this.printClientCall().toString());
        }
        return url.toString();
    }

    protected StringBuilder printClientCall() {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this.hostname).append(":").append(this.port);
        url.append(this.urlRequest);
        StringBuilder sb = new StringBuilder();
        sb.append("Client client = ClientFactory.newClient();\n");
        for (Object object : this.providersToRegister) {
            sb.append("client.configuration().register(");
            if (object instanceof Class) {
                sb.append(((Class)object).getName()).append(".class");
            } else {
                sb.append(object.getClass().getName());
            }
            sb.append(");\n");
        }
        sb.append("WebTarget target = client.target(\"").append(url.toString()).append("\");\n");
        sb.append("Invocation.Builder builder;\n");
        sb.append("builder = target.request(\"").append(this.getAcceptMediaType()).append("\");\n");
        for (Map.Entry entry : this.headerMap.entrySet()) {
            sb.append("builder.header(\"").append((String)entry.getKey()).append("\",\"").append((String)entry.getValue()).append("\");\n");
        }
        sb.append("Invocation i;\n");
        sb.append("i=builder.build(\"").append(this.requestType).append("\"");
        if (this.entity != null) {
            sb.append(",").append("Entity.entity(").append(this.entity.toString()).append(",").append(this.getContentType());
        }
        sb.append(");\n");
        sb.append("i.invoke();\n");
        return sb;
    }

    protected Invocation buildRequest(WebTarget target) {
        Invocation i;
        Invocation.Builder builder = target.request(new String[]{this.getAcceptMediaType()});
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            if (entry.getKey().equals("Accept")) continue;
            builder.header(entry.getKey(), (Object)entry.getValue());
        }
        if (this.entity != null) {
            i = this.entity instanceof Entity ? builder.build(this.requestType, (Entity)this.entity) : builder.build(this.requestType, Entity.entity((Object)this.entity, (String)this.getContentType()));
            TestUtil.logMsg((String)("[Request] Adding entity: " + this.entity));
        } else {
            i = builder.build(this.requestType);
        }
        return i;
    }

    protected Response invoke(Invocation invocation) throws TestFailureException {
        Response response = null;
        switch (this.executionType) {
            case SYNCHRONOUS: {
                response = invocation.invoke();
                break;
            }
            case ASYNCHRONOUS: {
                int cnt = 0;
                try {
                    final boolean[] buffered = new boolean[]{false};
                    InvocationCallback<Response> callback = new InvocationCallback<Response>(){

                        public void completed(Response res) {
                            try {
                                JaxrsWebTestCase.this.response = res;
                                JaxrsWebTestCase.this.getResponse().getResponseBodyAsString();
                                buffered[0] = true;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void failed(Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                    };
                    Future future = invocation.submit((InvocationCallback)callback);
                    while (!buffered[0] && cnt++ < 50) {
                        Thread.sleep(100L);
                    }
                    response = (Response)future.get();
                }
                catch (Exception e) {
                    throw new TestFailureException((Throwable)e);
                }
                if (cnt <= 49) break;
                throw new TestFailureException("Invocation callback has not been called within 5 second");
            }
        }
        return response;
    }

    protected String getAcceptMediaType() {
        String media = this.headerMap.get("Accept");
        if (media == null) {
            media = "*/*";
        }
        return media;
    }

    protected String getContentType() {
        String media = this.headerMap.get("Content-Type");
        if (media == null) {
            media = "*/*";
        }
        return media;
    }

    public HttpRequest getRequest() {
        if (super.getRequest() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.requestType).append(" ").append(this.urlRequest).append("/");
            sb.append(" HTTP/1.1");
            super.setRequest((HttpRequest)new ApacheRequestAdapter(sb.toString(), this.hostname, this.port));
        }
        return super.getRequest();
    }

    public synchronized HttpResponse getResponse() {
        if (this._response == null) {
            this._response = new ApacheResponseAdapter(this.response, this.hostname, this.port, this.textCaser);
        }
        return this._response;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUrlRequest() {
        return this.urlRequest;
    }

    public void setUrlRequest(String urlRequest) {
        this.urlRequest = urlRequest;
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public Response getJaxrsResponse() {
        return this.response;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public Request getJaxrsRequest() {
        return this.request;
    }

    public boolean isPrintedEntity() {
        return this.printEntity;
    }

    public void setPrintEntity(boolean printEntity) {
        this.printEntity = printEntity;
    }

    public void bufferEntity(boolean bufferEntity) {
        this.bufferEntity = bufferEntity;
    }

    public List<Object> getProvidersToRegister() {
        return this.providersToRegister;
    }

    public void addProviderToRegister(Object providerToRegister) {
        this.providersToRegister.add(providerToRegister);
    }

    public void setPrintClientCall(boolean print) {
        this.printClientCall = print;
    }

    public void setProcessingType(Execution type) {
        this.executionType = type;
    }

    public TextCaser getTextCaser() {
        return this.textCaser;
    }

    public void setTextCaser(TextCaser textCaser) {
        this.textCaser = textCaser;
    }

    protected static enum Execution {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

