/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.escapeSyntax.scalar2;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.fnSchema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class scalarClient2
extends ServiceEETest {
    private static final String testName = "jdbc.ee.escapeSyntax";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private String drManager = null;
    private fnSchema fnSch = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        scalarClient2 theTests = new scalarClient2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.fnSch = new fnSchema();
                this.fnSch.createTable(p, this.conn);
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!", e);
        }
    }

    public void testAbs() throws Exception {
        try {
            String queryString = null;
            queryString = this.props.getProperty("Abs_Fn_Query", "");
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("Absolute value : " + retString);
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testAbs Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAbs Failed!");
        }
    }

    public void testPower() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("POWER", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function POWER  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function POWER is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testPower failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Power_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Power value : " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testPower Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testPower Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRound() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("ROUND", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function ROUND  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function ROUND is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRound failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Round_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Rounded value : " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRound failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRound failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSign() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("SIGN", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function SIGN  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function SIGN is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSign failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Sign_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Sign value : " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testSign failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testSign failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSqrt() throws Exception {
        try {
            String queryString = null;
            this.msg.setMsg("Query that contains a call to the function sqrt");
            queryString = this.props.getProperty("Sqrt_Fn_Query", "");
            this.msg.setMsg("queryString");
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("Sqrt value : " + retString);
            this.rs.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testSqrt Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSqrt Failed!");
        }
    }

    public void testTruncate() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("TRUNCATE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function TRUNCATE  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function TRUNCATE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testTruncate failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                this.msg.setMsg("Query that contains a call to the function truncate");
                queryString = this.props.getProperty("Truncate_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Truncated Number: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testTruncate Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testTruncate Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testMod() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("MOD", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function MOD  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function MOD is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testMod failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                this.msg.setMsg("Query that contains a call to the function mod");
                queryString = this.props.getProperty("Mod_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Remainder value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testMod Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testMod Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testFloor() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("FLOOR", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function FLOOR  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function FLOOR is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testFloor failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                this.msg.setMsg("Query that contains a call to the function floor");
                queryString = this.props.getProperty("Floor_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Largest Integer: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testFloor failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testFloor failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testCeiling() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("CEILING", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function CEILING  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function CEILING is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testCeiling failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                this.msg.setMsg("Query that contains a call to the function ceiling");
                queryString = this.props.getProperty("Ceiling_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Smallest Integer: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testCeiling failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testCeiling failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLog10() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("LOG10", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function LOG10  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function LOG10 is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLog10 failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Log10_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Log10 value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testLog10 failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testLog10 failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLog() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("LOG", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function LOG  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function LOG is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLog failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Log_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Log e  value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testLog failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testLog failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testExp() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("EXP", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function EXP  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function EXP is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testExp failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Exp_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Exponential value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testExp failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testExp failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testCos() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("COS", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function COS  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function COS is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testCos failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Cos_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("COS value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testCos failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testCos failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testTan() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("TAN", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function TAN  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function TAN is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testTan failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Tan_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("TAN value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testTan failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testTan failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testCot() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("COT", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function COT  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function COT is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testCot failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Cot_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("COT value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testCot failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testCot failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testCurdate() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("CURDATE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function CURDATE  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function CURDATE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testCurdate failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Curdate_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Current Date  value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testCurdate failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testCurdate failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDayname() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("DAYNAME", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function DAYNAME  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function DAYNAME is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDayname failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Dayname_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Day Name: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDayname failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDayname failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDayofmonth() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("DAYOFMONTH", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function DAYOFMONTH  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function DAYOFMONTH is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDayofmonth failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Dayofmonth_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Day of Month: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDayofmonth failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDayofmonth failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDayofweek() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("DAYOFWEEK", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function DAYOFWEEK  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function DAYOFWEEK is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDayofweek failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Dayofweek_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Day of Week: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDayofweek failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDayofweek failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDayofyear() throws Exception {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("DAYOFYEAR", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function DAYOFYEAR  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function DAYOFYEAR is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDayofyear failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Dayofyear_Fn_Query", "");
                this.msg.setMsg(queryString);
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Day of Year: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDayofyear failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDayofyear failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.fnSch.dropTable(this.props, this.conn);
            this.fnSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

