/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt22;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient22
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt22";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient22 theTests = new callStmtClient22();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter49() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sMfgDate = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDate = sMfgDate.substring(sMfgDate.indexOf(39) + 1, sMfgDate.lastIndexOf(39));
            Date mfgDate = Date.valueOf(sMfgDate);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Io_Null(?)}");
            this.cstmt.setObject(1, (Object)mfgDate);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Date oRetVal = (Date)this.cstmt.getObject(1);
            this.msg.addOutputMsg(" " + mfgDate, "" + oRetVal);
            if (mfgDate.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter50() throws Exception {
        String sBrkTime = null;
        Time brkTime = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            sBrkTime = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sBrkTime = sBrkTime.substring(sBrkTime.indexOf(39) + 1, sBrkTime.lastIndexOf(39));
            brkTime = Time.valueOf(sBrkTime);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Io_Null(?)}");
            this.cstmt.setObject(1, (Object)brkTime);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            java.util.Date dRetVal = (java.util.Date)this.cstmt.getObject(1);
            long lDate = dRetVal.getTime();
            Time oRetVal = new Time(lDate);
            this.msg.addOutputMsg(" " + brkTime, "" + oRetVal);
            if (brkTime.toString().trim().equals(oRetVal.toString().trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter51() throws Exception {
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            String sInTime = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sInTime = sInTime.substring(sInTime.indexOf(39) + 1, sInTime.lastIndexOf(39));
            Timestamp inTimestamp = Timestamp.valueOf(sInTime);
            this.msg.setMsg("Timestamp value to be updated   :   " + inTimestamp);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Io_Null(?)}");
            this.cstmt.setObject(1, (Object)inTimestamp);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Timestamp oRetVal = (Timestamp)this.cstmt.getObject(1);
            this.msg.addOutputMsg(" " + inTimestamp, "" + oRetVal);
            if (inTimestamp.compareTo(oRetVal) == 0) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter52() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String binarySize = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.sqlp.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc_Io(?)}");
            this.cstmt.setObject(1, (Object)bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            retByteArr = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter53() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            varbinarySize = this.sqlp.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc_Io(?)}");
            this.cstmt.setObject(1, (Object)bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            retByteArr = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter54() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String longvarbinarySize = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            longvarbinarySize = this.sqlp.getProperty("longvarbinarySize");
            this.msg.setMsg("Longvarbinary Table Size : " + longvarbinarySize);
            int bytearrsize = Integer.parseInt(longvarbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Io(?)}");
            this.cstmt.setObject(1, (Object)bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            retByteArr = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

