/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.common;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.assembly.common.AssemblyCommonIF;
import com.sun.ts.tests.ejb30.assembly.common.AssemblyRemoteIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import java.util.Properties;

public class ClientBase
extends EETest {
    @EJB(name="remoteAssemblyBean", beanInterface=AssemblyRemoteIF.class)
    protected static AssemblyCommonIF remoteAssemblyBean;
    @EJB(name="helloBean")
    private static HelloRemoteIF helloBean;
    private static int postConstructCallsCount;
    private Properties props;

    public static void main(String[] args) {
        ClientBase theTests = new ClientBase();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    @PostConstruct
    private static void postConstruct() {
        ++postConstructCallsCount;
    }

    public void postConstructInvokedInSuperElseWhere() throws Exception {
        if (postConstructCallsCount <= 0) {
            throw new Exception("Expecting the Client.PostConstruct to be invoked  at least once, but actual " + postConstructCallsCount);
        }
        TLogger.log("Got expected result.  Client.PostConstruct method is invoked " + postConstructCallsCount + " times");
    }

    public void remoteAdd() throws Exception {
        int a = 1;
        int b = 2;
        int additionalByInterceptor = 200;
        int expected = a + b + additionalByInterceptor;
        int actual = remoteAssemblyBean.remoteAdd(a, b);
        if (actual != expected) {
            throw new Exception("Expecting " + expected + ", but actual " + actual + ". The interceptor may not have been invoked.");
        }
        TLogger.log("Got expected result: " + expected);
    }

    public void remoteAddByHelloEJB() throws Exception {
        int a = 1;
        int b = 1;
        int expected = a + b;
        int actual = helloBean.add(a, b);
        if (actual != expected) {
            throw new Exception("Expecting helloBean.add to return " + expected + ", but actual was " + actual);
        }
        TLogger.log("Got expected result from calling helloBean.");
    }

    public void remoteAddByHelloEJBFromAssemblyBean() throws Exception {
        String result = remoteAssemblyBean.callHelloBean();
        if (result == null) {
            throw new Exception("Expecting a non-null result from remoteAssemblyBean.callHelloBean(), but got null.");
        }
        TLogger.log("Got expected result: " + result);
    }

    public void cleanup() throws Exception {
    }
}

