/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.mapkeyjoincolumn;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.mapkeyjoincolumn.Course;
import ee.jakarta.tck.persistence.jpa22.repeatable.mapkeyjoincolumn.Semester;
import ee.jakarta.tck.persistence.jpa22.repeatable.mapkeyjoincolumn.Student;
import jakarta.persistence.EntityManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    private Map<Course, Semester> student7EnrollmentMap;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void mapKeyJoinColumnTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.createTestData();
            this.getEntityManager().flush();
            this.clearCache();
            this.clearCache();
            Student student = (Student)this.getEntityManager().find(Student.class, (Object)7);
            Set<Course> courses = student.getCourses();
            if (courses.containsAll(this.student7EnrollmentMap.keySet()) && this.student7EnrollmentMap.keySet().containsAll(courses) && courses.size() == this.student7EnrollmentMap.keySet().size()) {
                pass = true;
            }
            this.clearCache();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("mapKeyJoinColumn Failed");
        }
    }

    public void createTestData() {
        Student student1 = new Student(1, "Neo");
        Student student2 = new Student(2, "Vivek");
        Student student3 = new Student(3, "Arun");
        Student student4 = new Student(4, "Ganesh");
        Student student5 = new Student(5, "Ram");
        Student student6 = new Student(6, "Rahim");
        Student student7 = new Student(7, "Joseph");
        Student student8 = new Student(8, "Krishna");
        Semester semester1 = new Semester(1);
        Semester semester2 = new Semester(2);
        Semester semester3 = new Semester(3);
        Semester semester4 = new Semester(4);
        Course appliedMath = new Course(101, "AppliedMathematics");
        Course physics = new Course(102, "Physics");
        Course operationResearch = new Course(103, "OperationResearch");
        Course statistics = new Course(201, "Statistics");
        Course operatingSystem = new Course(202, "OperatingSystem");
        Course numericalMethods = new Course(203, "NumericalMethods");
        Course graphics = new Course(301, "Graphics");
        Course accountancy = new Course(302, "Accountancy");
        Course mis = new Course(303, "ManagementInformationSystem");
        Course cad = new Course(401, "ComputerAidedDesign");
        Course compilerDesign = new Course(402, "CompilerDesign");
        Course ood = new Course(403, "ObjectOrientedDesignAndAnalysis");
        Hashtable<Course, Semester> student1EnrollmentMap = new Hashtable<Course, Semester>();
        student1EnrollmentMap.put(appliedMath, semester1);
        student1EnrollmentMap.put(physics, semester1);
        student1EnrollmentMap.put(operationResearch, semester1);
        student1EnrollmentMap.put(statistics, semester2);
        student1EnrollmentMap.put(operatingSystem, semester2);
        student1EnrollmentMap.put(numericalMethods, semester2);
        student1.setEnrollment(student1EnrollmentMap);
        Hashtable<Course, Semester> student2EnrollmentMap = new Hashtable<Course, Semester>();
        student2EnrollmentMap.put(appliedMath, semester1);
        student2EnrollmentMap.put(physics, semester1);
        student2EnrollmentMap.put(operationResearch, semester1);
        student2EnrollmentMap.put(graphics, semester3);
        student2EnrollmentMap.put(accountancy, semester3);
        student2EnrollmentMap.put(mis, semester3);
        student2.setEnrollment(student2EnrollmentMap);
        Hashtable<Course, Semester> student3EnrollmentMap = new Hashtable<Course, Semester>();
        student3EnrollmentMap.put(statistics, semester2);
        student3EnrollmentMap.put(operatingSystem, semester2);
        student3EnrollmentMap.put(numericalMethods, semester2);
        student3EnrollmentMap.put(graphics, semester3);
        student3EnrollmentMap.put(accountancy, semester3);
        student3EnrollmentMap.put(mis, semester3);
        student3.setEnrollment(student3EnrollmentMap);
        Hashtable<Course, Semester> student4EnrollmentMap = new Hashtable<Course, Semester>();
        student4EnrollmentMap.put(statistics, semester2);
        student4EnrollmentMap.put(operatingSystem, semester2);
        student4EnrollmentMap.put(numericalMethods, semester2);
        student4EnrollmentMap.put(cad, semester4);
        student4EnrollmentMap.put(compilerDesign, semester4);
        student4EnrollmentMap.put(ood, semester4);
        student4.setEnrollment(student4EnrollmentMap);
        Hashtable<Course, Semester> student5EnrollmentMap = new Hashtable<Course, Semester>();
        student5EnrollmentMap.put(graphics, semester3);
        student5EnrollmentMap.put(accountancy, semester3);
        student5EnrollmentMap.put(mis, semester3);
        student5.setEnrollment(student5EnrollmentMap);
        Hashtable<Course, Semester> student6EnrollmentMap = new Hashtable<Course, Semester>();
        student6EnrollmentMap.put(graphics, semester3);
        student6EnrollmentMap.put(accountancy, semester3);
        student6EnrollmentMap.put(mis, semester3);
        student6EnrollmentMap.put(cad, semester4);
        student6EnrollmentMap.put(compilerDesign, semester4);
        student6EnrollmentMap.put(ood, semester4);
        student6.setEnrollment(student6EnrollmentMap);
        this.student7EnrollmentMap = new Hashtable<Course, Semester>();
        this.student7EnrollmentMap.put(appliedMath, semester1);
        this.student7EnrollmentMap.put(physics, semester1);
        this.student7EnrollmentMap.put(operationResearch, semester1);
        this.student7EnrollmentMap.put(cad, semester4);
        this.student7EnrollmentMap.put(compilerDesign, semester4);
        this.student7EnrollmentMap.put(ood, semester4);
        student7.setEnrollment(this.student7EnrollmentMap);
        Hashtable<Course, Semester> student8EnrollmentMap = new Hashtable<Course, Semester>();
        student8EnrollmentMap.put(appliedMath, semester2);
        student8EnrollmentMap.put(physics, semester2);
        student8EnrollmentMap.put(operationResearch, semester2);
        student8EnrollmentMap.put(cad, semester4);
        student8EnrollmentMap.put(compilerDesign, semester4);
        student8EnrollmentMap.put(ood, semester4);
        student8.setEnrollment(student8EnrollmentMap);
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist((Object)student1);
        entityManager.persist((Object)student2);
        entityManager.persist((Object)student3);
        entityManager.persist((Object)student4);
        entityManager.persist((Object)student5);
        entityManager.persist((Object)student6);
        entityManager.persist((Object)student7);
        entityManager.persist((Object)student8);
        this.logTrace("persisted 8 students");
        entityManager.persist((Object)semester1);
        entityManager.persist((Object)semester2);
        entityManager.persist((Object)semester3);
        entityManager.persist((Object)semester4);
        this.logTrace("persisted 4 semesters");
        entityManager.persist((Object)appliedMath);
        entityManager.persist((Object)physics);
        entityManager.persist((Object)operationResearch);
        entityManager.persist((Object)statistics);
        entityManager.persist((Object)operatingSystem);
        entityManager.persist((Object)numericalMethods);
        entityManager.persist((Object)graphics);
        entityManager.persist((Object)accountancy);
        entityManager.persist((Object)mis);
        entityManager.persist((Object)cad);
        entityManager.persist((Object)compilerDesign);
        entityManager.persist((Object)ood);
        this.logTrace("persisted 12 Courses");
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from ENROLLMENTS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from SEMESTER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

