/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex3a;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3Dependent;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3DependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3Employee;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3EmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void DIDTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID3EmployeeId eId1 = new DID3EmployeeId("Java", "Duke");
            DID3EmployeeId eId2 = new DID3EmployeeId("C", "foo");
            DID3Employee employee1 = new DID3Employee(eId1);
            DID3Employee employee2 = new DID3Employee(eId2);
            DID3DependentId depId1 = new DID3DependentId("Obama", eId1);
            DID3DependentId depId2 = new DID3DependentId("Michelle", eId1);
            DID3DependentId depId3 = new DID3DependentId("John", eId2);
            DID3Dependent dep1 = new DID3Dependent(depId1, employee1);
            DID3Dependent dep2 = new DID3Dependent(depId2, employee1);
            DID3Dependent dep3 = new DID3Dependent(depId3, employee2);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().flush();
            this.logTrace("persisted Employees and Dependents");
            DID3Dependent newDependent = (DID3Dependent)this.getEntityManager().find(DID3Dependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID3Dependent d where d.name2='Obama' and d.emp.empId.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID3Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    this.logTrace("Received Expected Dependent");
                } else {
                    this.logErr("Searched Dependent not found");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DTDTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

