/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.Root;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Department;
import ee.jakarta.tck.persistence.common.schema30.Department_;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;

public class Client4
extends Util {
    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees");
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinMapStringTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinMapStringJoinTypeTest failed");
        }
    }
}

