/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.embeddable;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.embeddable.Address;
import ee.jakarta.tck.persistence.core.annotations.embeddable.B;
import ee.jakarta.tck.persistence.core.annotations.embeddable.ZipCode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EM1XMTest() throws Exception {
        this.logTrace("Begin EM1XMTest2");
        boolean pass = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            et.begin();
            this.logTrace("New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            addr1.setZipCode(z1);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            em.persist((Object)b1);
            em.flush();
            B newB = this.findB("1");
            em.refresh((Object)newB);
            String newStreet = (String)em.createQuery("Select b.address.street from B b ").getSingleResult();
            String newState = (String)em.createQuery("Select b.address.state from B b ").getSingleResult();
            String newCity = (String)em.createQuery("Select b.address.city from B b ").getSingleResult();
            String newPlusFour = (String)em.createQuery("Select b.address.zipCode.plusFour from B b ").getSingleResult();
            String newZip = (String)em.createQuery("Select b.address.zipCode.zip from B b ").getSingleResult();
            boolean pass1 = false;
            boolean pass2 = false;
            boolean pass3 = false;
            boolean pass4 = false;
            boolean pass5 = false;
            if (addr1.getStreet().equals(newStreet)) {
                pass1 = true;
                this.logTrace("Received Street match");
            }
            if (addr1.getState().equals(newState)) {
                pass2 = true;
                this.logTrace("Received State match");
            }
            if (addr1.getCity().equals(newCity)) {
                pass3 = true;
                this.logTrace("Received City match");
            }
            if (addr1.getZipCode().getPlusFour().equals(newPlusFour)) {
                pass4 = true;
                this.logTrace("Received zipCode PlusFour match");
            }
            if (addr1.getZipCode().getZip().equals(newZip)) {
                pass5 = true;
                this.logTrace("Received zipCode zip match");
            }
            if (pass1 && pass2 && pass3 && pass4 && pass5) {
                pass = true;
                this.logTrace("Received Address match");
            } else {
                this.logTrace("Received incorrect data");
            }
            et.commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("EM1XMTest failed");
        }
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from B_EMBEDDABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

