/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.transactional;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.jta.ee.transactional.CTSDontRollbackException;
import com.sun.ts.tests.jta.ee.transactional.CTSRollbackException;
import com.sun.ts.tests.jta.ee.transactional.Helper;
import com.sun.ts.tests.jta.ee.transactional.OneManagedBean;
import com.sun.ts.tests.jta.ee.transactional.OneManagedQualifier;
import com.sun.ts.tests.jta.ee.transactional.TransactionScopedBean;
import com.sun.ts.tests.jta.ee.transactional.TwoManagedBean;
import com.sun.ts.tests.jta.ee.transactional.TwoManagedQualifier;
import jakarta.annotation.Resource;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.inject.Inject;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.TransactionalException;
import jakarta.transaction.UserTransaction;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class Client
extends EJBLiteClientBase {
    private static StringBuilder callRecords = new StringBuilder();
    @Inject
    @OneManagedQualifier
    OneManagedBean one;
    @Inject
    TransactionScopedBean tscopedBean;
    @Resource(lookup="java:comp/UserTransaction")
    private UserTransaction ut;
    @Inject
    @TwoManagedQualifier
    TwoManagedBean two;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void txTypeRequired_withoutTransaction() throws Exception {
        Helper.assertEquals("\n", "txTypeRequired called successfully", this.one.txTypeRequired(), callRecords);
        this.appendReason(Helper.compareResult("txTypeRequired called successfully", this.one.txTypeRequired()));
    }

    public void txTypeRequired_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeRequired called successfully", this.one.txTypeRequired(), callRecords);
            this.appendReason(Helper.compareResult("txTypeRequired called successfully", this.one.txTypeRequired()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequired_withTransaction failed");
        }
    }

    public void txTypeRequired_IllegalStateException() throws Exception {
        Helper.assertEquals(null, "IllegalStateException", this.one.txTypeRequiredIllegalStateException(), callRecords);
        this.appendReason(Helper.compareResult("IllegalStateException", this.one.txTypeRequiredIllegalStateException()));
    }

    public void txTypeRequiresNew() throws Exception {
        Helper.assertEquals(null, "txTypeRequiresNew called successfully", this.one.txTypeRequiresNew(), callRecords);
        this.appendReason(Helper.compareResult("txTypeRequiresNew called successfully", this.one.txTypeRequiresNew()));
    }

    public void txTypeRequiresNew_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeRequiresNew called successfully", this.one.txTypeRequiresNew(), callRecords);
            this.appendReason(Helper.compareResult("txTypeRequiresNew called successfully", this.one.txTypeRequiresNew()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequiresNew_withTransaction failed");
        }
    }

    public void txTypeMandatory_withoutTransaction() throws Exception {
        Object result = "TransactionalException not received";
        try {
            Helper.getLogger().info("Invoking OneManagedBean.txTypeManadatory() without a transaction Context");
            this.one.txTypeMandatory();
        }
        catch (TransactionalException te) {
            if (te.getCause() instanceof TransactionRequiredException) {
                result = "Received expected TransactionalException with nested TransactionRequiredException";
            }
            throw new Exception("Received TransactionalException without nested TransactionRequiredExecption");
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Received unexcepted Exception :" + e.getMessage();
        }
        if (!((String)result).equals("Received expected TransactionalException with nested TransactionRequiredException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason("Received expected TransactionalException with nested TransactionRequiredException");
    }

    public void txTypeMandatory_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeMandatory called successfully", this.one.txTypeMandatory(), callRecords);
            this.appendReason(Helper.compareResult("txTypeMandatory called successfully", this.one.txTypeMandatory()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequiresNew_withTransaction failed");
        }
    }

    public void txTypeSupports_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeSupports run without active transaction", this.one.txTypeSupportsWithoutTransaction(), callRecords);
        this.appendReason(Helper.compareResult("txTypeSupports run without active transaction", this.one.txTypeSupportsWithoutTransaction()));
    }

    public void txTypeSupports_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeSupports called successfully", this.one.txTypeSupports(), callRecords);
            this.appendReason(Helper.compareResult("txTypeSupports called successfully", this.one.txTypeSupports()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeSupports failed");
        }
    }

    public void txTypeNotSupported_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeNotSupported run without active transaction", this.one.txTypeNotSupported(), callRecords);
        this.appendReason(Helper.compareResult("txTypeNotSupported run without active transaction", this.one.txTypeNotSupported()));
    }

    public void txTypeNotSupported_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeNotSupported run without active transaction", this.one.txTypeNotSupported(), callRecords);
            this.appendReason(Helper.compareResult("txTypeNotSupported run without active transaction", this.one.txTypeNotSupported()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeSupports failed");
        }
    }

    public void txTypeNever_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeNever run without active transaction", this.one.txTypeNever(), callRecords);
        this.appendReason(Helper.compareResult("txTypeNever run without active transaction", this.one.txTypeNever()));
    }

    public void txTypeNever_withTransaction() throws Exception {
        Object result = "Expected TransactionalException not received";
        try {
            Helper.getLogger().info("Invoking OneManagedBean.txTypeNever() with a transaction Context");
            this.ut.begin();
            this.one.txTypeNever();
            this.ut.commit();
        }
        catch (TransactionalException te) {
            if (te.getCause() instanceof InvalidTransactionException) {
                result = "Received expected TransactionalException with nested InvalidTransactionException";
            }
            throw new Exception("Received expected TransactionalException without nested InvalidTransactionException");
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Received unexcepted Exception :" + e.getMessage();
        }
        if (!((String)result).equals("Received expected TransactionalException with nested InvalidTransactionException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason("Received expected TransactionalException with nested InvalidTransactionException");
    }

    public void rollbackOnException() throws Exception {
        Object result = "failed to set STATUS_MARKED_ROLLBACK on CTSRollbackException";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackOnException()");
                this.one.rollbackOnException();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 1) {
                    result = "Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void rollbackOnExceptionTwo() throws Exception {
        Object result = "failed to set STATUS_MARKED_ROLLBACK on CTSRollbackException";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackOnException()");
                this.two.rollbackOnException();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 1) {
                    result = "Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void dontRollbackOnException() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.dontRollbackOnException()");
                this.one.dontRollbackOnException();
            }
        }
        catch (CTSDontRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSDontRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSDontRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSDontRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void dontRollbackOnExceptionTwo() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling two.dontRollbackOnException()");
                this.two.dontRollbackOnException();
            }
        }
        catch (CTSDontRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSDontRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSDontRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSDontRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void rollbackAndDontRollback() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackAndDontRollback()");
                this.one.rollbackAndDontRollback();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void rollbackAndDontRollbackTwo() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling two.rollbackAndDontRollback()");
                this.two.rollbackAndDontRollback();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void transactionScopedBean_withoutTransaction() throws Exception {
        Object result = "ContextNotActiveException not received";
        try {
            Helper.getLogger().info("Invoking TransactionScopedBean.test() without a transaction Context");
            this.tscopedBean.test();
        }
        catch (ContextNotActiveException te) {
            result = "Received expected ContextNotActiveException";
        }
        catch (Exception e) {
            result = "Received unexcepted Exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Received expected ContextNotActiveException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void transactionScopedBean_withTransaction() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            Helper.getLogger().info("Invoking TransactionScopedBean.test() with a transaction Context");
            result = this.tscopedBean.test();
            this.ut.commit();
        }
        catch (Exception e) {
            result = "Received unexcepted Exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("TransactionScopedBean.test called with active transaction")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    public void getInterceptorPriorityForTxTypeRequired() throws Exception {
        String methodName = "txTypeRequired";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.REQUIRED");
    }

    public void getInterceptorPriorityForTxTypeRequiresNew() throws Exception {
        String methodName = "txTypeRequiresNew";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.REQUIRES_NEW");
    }

    public void getInterceptorPriorityForTxTypeMandatory() throws Exception {
        String methodName = "txTypeMandatory";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.MANDATORY");
    }

    public void getInterceptorPriorityForTxTypeSupports() throws Exception {
        String methodName = "txTypeSupports";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.SUPPORTS");
    }

    public void getInterceptorPriorityForTxTypeNotSupported() throws Exception {
        String methodName = "txTypeNotSupported";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.NOT_SUPPORTED");
    }

    public void getInterceptorPriorityForTxTypeNever() throws Exception {
        String methodName = "txTypeNever";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.NEVER");
    }

    private void verifyInterceptorPriority(List<Integer> priorityList, String txType) throws Exception {
        String result = null;
        if (!priorityList.contains(200)) {
            throw new Exception("Transactional Interceptor for " + txType + " has incorrect interceptor priority : " + Arrays.toString(priorityList.toArray()) + " Excpected value is :0200");
        }
        Helper.getLogger().log(Level.INFO, "Transactional Interceptor for " + txType + " has right interceptor priority");
        result = "Transactional Interceptor for " + txType + " has right interceptor priority";
        if (result != null) {
            this.appendReason(result);
        }
    }
}

