/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.util;

import jakarta.el.ELContext;
import jakarta.el.PropertyNotWritableException;
import jakarta.servlet.jsp.el.ImplicitObjectELResolver;
import jakarta.servlet.jsp.el.ScopedAttributeELResolver;

public class JspResolverTest {
    private JspResolverTest() {
    }

    public static boolean testImplicitObjELResolver(ELContext elContext, ImplicitObjectELResolver resolver, Object base, Object property, Object value, StringBuffer buf) throws ClassNotFoundException {
        boolean pass = true;
        buf.append("base is " + base + "\n");
        buf.append("property is " + property + "\n");
        buf.append("value is " + value + "\n");
        elContext.setPropertyResolved(false);
        try {
            resolver.setValue(elContext, base, property, value);
            if (base != null) {
                buf.append("setValue() returned when base was non-null\n");
            } else {
                buf.append("setValue() allowed to write a value\n");
                pass = false;
            }
        }
        catch (PropertyNotWritableException pnwe) {
            if (base != null) {
                buf.append("setValue() - PropertyNotWritableException ");
                buf.append("when base is non-null\n");
                pass = false;
            }
            buf.append("setValue() tested successfully\n");
            buf.append("PropertyNotWritableException caught as expected\n");
        }
        elContext.setPropertyResolved(false);
        Object valueRetrieved = resolver.getValue(elContext, base, property);
        if (base != null) {
            buf.append("getValue() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("getValue() did not resolve\n");
            pass = false;
        } else {
            buf.append("getValue() tested successfully\n");
            buf.append("Value retrieved: " + valueRetrieved.toString() + "\n");
        }
        elContext.setPropertyResolved(false);
        Class type = resolver.getType(elContext, base, property);
        if (base != null) {
            buf.append("getType() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("getType() did not resolve\n");
            pass = false;
        } else if (type != null) {
            buf.append("getType() did not return null as expected\n");
            pass = false;
        } else {
            buf.append("getType() returns null as expected\n");
        }
        elContext.setPropertyResolved(false);
        boolean readOnly = resolver.isReadOnly(elContext, base, property);
        if (base != null) {
            buf.append("isReadOnly() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve\n");
            pass = false;
        } else if (!readOnly) {
            buf.append("isReadOnly() returned false\n");
            pass = false;
        } else {
            buf.append("isReadOnly() returns true as expected\n");
        }
        elContext.setPropertyResolved(false);
        Class commonPropertyType = resolver.getCommonPropertyType(elContext, base);
        if (base != null) {
            if (commonPropertyType != null) {
                buf.append("getCommonPropertyType() returned non-null value ");
                buf.append("for non-null value of base\n");
                pass = false;
            } else {
                buf.append("getCommonPropertyType() returned null value ");
                buf.append("for non-null value of base as expected\n");
            }
        } else if (commonPropertyType != Class.forName("java.lang.String")) {
            buf.append("getCommonPropertyType did not return String as expecte\n");
            pass = false;
        } else {
            buf.append("getCommonPropertyType() returns Class java.lang.String\n");
        }
        return pass;
    }

    public static boolean testScopedAttrELResolver(ELContext elContext, ScopedAttributeELResolver resolver, Object base, Object property, Object value, StringBuffer buf) throws ClassNotFoundException {
        boolean pass = true;
        buf.append("base is " + base + "\n");
        buf.append("property is " + property + "\n");
        buf.append("value is " + value + "\n");
        elContext.setPropertyResolved(false);
        try {
            resolver.setValue(elContext, base, property, value);
            if (base != null) {
                buf.append("setValue() returned when base was non-null\n");
            } else {
                buf.append("setValue() allowed to write a value as expected\n");
            }
        }
        catch (PropertyNotWritableException pnwe) {
            buf.append("setValue() - PropertyNotWritableException ");
            pass = false;
        }
        elContext.setPropertyResolved(false);
        Object valueRetrieved = resolver.getValue(elContext, base, property);
        if (base != null) {
            buf.append("getValue() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("getValue() did not resolve\n");
            pass = false;
        } else if (valueRetrieved == null) {
            buf.append("Unexpected null value for valueRetrieved\n");
            pass = false;
        } else if (valueRetrieved.toString().equals(value.toString())) {
            buf.append("getValue() tested successfully\n");
        } else {
            buf.append("getValue() returned incorrect value:\n");
            buf.append("Value retrieved: " + valueRetrieved.toString() + "\n");
            buf.append("Value expected: " + value.toString() + "\n");
            pass = false;
        }
        elContext.setPropertyResolved(false);
        Class type = resolver.getType(elContext, base, property);
        if (base != null) {
            buf.append("getType() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("getType() did not resolve\n");
            pass = false;
        } else if (type == null) {
            buf.append("getType() returned null unexpectedly\n");
            pass = false;
        } else if (type == Class.forName("java.lang.Object")) {
            buf.append("getType() returned Object as expected\n");
        } else {
            buf.append("getType() returned " + type.toString() + "\n");
            pass = false;
        }
        elContext.setPropertyResolved(false);
        boolean readOnly = resolver.isReadOnly(elContext, base, property);
        if (base != null) {
            buf.append("isReadOnly() returned when base was non-null\n");
        } else if (!elContext.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve\n");
            pass = false;
        } else if (readOnly) {
            buf.append("isReadOnly() returned true\n");
            pass = false;
        } else {
            buf.append("isReadOnly() returns false as expected\n");
        }
        elContext.setPropertyResolved(false);
        Class commonPropertyType = resolver.getCommonPropertyType(elContext, base);
        if (base != null) {
            if (commonPropertyType != null) {
                buf.append("getCommonPropertyType() returned non-null value ");
                buf.append("for non-null value of base\n");
                pass = false;
            } else {
                buf.append("getCommonPropertyType() returned null value ");
                buf.append("for non-null value of base as expected\n");
            }
        } else if (commonPropertyType != Class.forName("java.lang.String")) {
            buf.append("getCommonPropertyType did not return String as expected\n");
            pass = false;
        } else {
            buf.append("getCommonPropertyType() returns Class java.lang.String\n");
        }
        return pass;
    }
}

