/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.ejb;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.AnotherInterface;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.BeanRemote;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.Lazy;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.ManagedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EjbInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EjbInjectionTest.class)).build();
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="ee"), @SpecAssertion(section="resource_lifecycle", id="ld"), @SpecAssertion(section="resource_lifecycle", id="mg")})
    public void testInjectionOfEjbs() {
        Bean managedBean = (Bean)this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)managedBean);
        ManagedBean instance = (ManagedBean)managedBean.create(creationalContext);
        assert (instance.getMyEjb() != null) : "EJB reference was not produced and injected into bean";
        assert (instance.getMyEjb().knockKnock().equals("We're home"));
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="mh")})
    public void testPassivationOfEjbs() throws Exception {
        Bean managedBean = (Bean)this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)managedBean);
        ManagedBean instance = (ManagedBean)managedBean.create(creationalContext);
        instance = (ManagedBean)this.activate(this.passivate(instance));
        assert (instance.getMyEjb() != null) : "EJB reference was not produced and injected into bean";
        assert (instance.getMyEjb().knockKnock().equals("We're home"));
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="ad")})
    public void testResourceBeanTypes() {
        Bean beanRemote = (Bean)this.getBeans(BeanRemote.class, new Annotation[]{new Lazy.Literal()}).iterator().next();
        assert (beanRemote.getTypes().size() == 3);
        assert (this.typeSetMatches(beanRemote.getTypes(), new Type[]{BeanRemote.class, Object.class, AnotherInterface.class}));
    }
}

