/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application;

import java.net.URL;
import org.htmlunit.TextPage;
import org.htmlunit.WebClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.jaxrs.JaxRsActivator;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ApplicationContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextTest.class)).withClass(JaxRsActivator.class)).withWebXml("web.xml")).withWebResource("SimplePage.html")).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="aa")
    public void testApplicationScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.contextPath + "TestServlet?test=servlet");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="ab")
    public void testApplicationScopeActiveDuringDoFilterMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="ac")
    public void testApplicationScopeActiveDuringServletContextListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.contextPath + "TestServlet?test=servletContextListener");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="ad")
    public void testApplicationScopeActiveDuringHttpSessionListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.contextPath + "TestServlet?test=httpSessionListener");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="af")
    public void testApplicationScopeActiveDuringServletRequestListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.contextPath + "TestServlet?test=servletRequestListener");
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="application_context_ee", id="e")
    public void testApplicationContextSharedBetweenServletRequests() throws Exception {
        WebClient webClient = new WebClient();
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        Assert.assertTrue((Double.parseDouble(firstRequestResult.getContent()) != 0.0 ? 1 : 0) != 0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertEquals((double)Double.parseDouble(secondRequestResult.getContent()), (double)Double.parseDouble(firstRequestResult.getContent()));
    }

    @Test(groups={"integration", "jaxrs"})
    @SpecAssertion(section="application_context_ee", id="e")
    public void testApplicationContextSharedBetweenJaxRsRequests() throws Exception {
        WebClient webClient = new WebClient();
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "rest/application-id");
        Assert.assertNotNull((Object)firstRequestResult.getContent());
        Assert.assertTrue((Double.parseDouble(firstRequestResult.getContent()) != 0.0 ? 1 : 0) != 0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "rest/application-id");
        Assert.assertNotNull((Object)secondRequestResult.getContent());
        Assert.assertEquals((double)Double.parseDouble(secondRequestResult.getContent()), (double)Double.parseDouble(firstRequestResult.getContent()));
    }
}

