/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.appclient.deploy.ejbref.casesens;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.appclient.deploy.ejbref.casesens.ReferencedBean;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;

@ExtendWith(value={ArquillianExtension.class})
public class Client
extends EETest {
    private static final String prefix = "java:comp/env/ejb/";
    private static final String bean1Lookup = "java:comp/env/ejb/Philosopher";
    private static final String bean2Lookup = "java:comp/env/ejb/philosopher";
    private static final String bean1RefName = "Voltaire";
    private static final String bean2RefName = "Rousseau";
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(testable=true)
    public static EnterpriseArchive createDeployment(@ArquillianResource TestArchiveProcessor archiveProcessor) throws IOException {
        URL sunAppClientUrl;
        JavaArchive ejbClient = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"appclient_dep_ejbref_casesens_client.jar");
        ejbClient.addPackages(true, new Package[]{Client.class.getPackage()});
        ejbClient.addPackages(true, new String[]{"com.sun.ts.lib.harness"});
        URL appClientUrl = Client.class.getResource("com/sun/ts/tests/appclient/deploy/ejbref/scope/appclient_dep_ejbref_casesens_client.xml");
        if (appClientUrl != null) {
            ejbClient.addAsManifestResource(appClientUrl, "application-client.xml");
        }
        if ((sunAppClientUrl = Client.class.getResource("/com/sun/ts/tests/appclient/deploy/ejbref/single/appclient_dep_ejbref_casesens_client.jar.sun-application-client.xml")) != null) {
            ejbClient.addAsManifestResource(sunAppClientUrl, "sun-application-client.xml");
        }
        ejbClient.addAsManifestResource((Asset)new StringAsset("Main-Class: com.sun.ts.tests.appclient.deploy.ejbref.casesens.Client\n"), "MANIFEST.MF");
        JavaArchive ejb = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"appclient_dep_ejbref_casesens_ejb.jar");
        ejb.addPackages(false, new String[]{"com.sun.ts.tests.assembly.util.refbean"});
        ejb.addPackages(false, new String[]{"com.sun.ts.tests.assembly.util.shared.ejbref.common"});
        ejb.addPackages(true, new Package[]{Client.class.getPackage()});
        URL resURL = Client.class.getResource("/com/sun/ts/tests/appclient/deploy/ejbref/scope/appclient_dep_ejbref_casesens_ejb.jar.sun-ejb-jar.xml");
        if (resURL != null) {
            ejb.addAsManifestResource(resURL, "sun-ejb-jar.xml");
        }
        if ((resURL = Client.class.getResource("/com/sun/ts/tests/appclient/deploy/ejbref/scope/appclient_dep_ejbref_casesens_ejb.xml")) != null) {
            ejb.addAsManifestResource(resURL, "ejb-jar.xml");
        }
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"appclient_dep_ejbref_scope.ear");
        ear.addAsModule((Archive)ejbClient);
        ear.addAsModule((Archive)ejb);
        return ear;
    }

    public void setup(String[] args, Properties props) throws Exception {
        this.props = props;
        try {
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Setup succeed (got naming context).");
        }
        catch (Exception e) {
            throw new Exception("[Client] Setup failed:", e);
        }
    }

    @Test
    public void testCaseSensitivity() throws Exception {
        ReferencedBean bean1 = null;
        ReferencedBean bean2 = null;
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"[Client] Looking up 'java:comp/env/ejb/Philosopher'...");
            bean1 = (ReferencedBean)this.nctx.lookup(bean1Lookup, ReferencedBean.class);
            bean1.createNamingContext();
            bean1.initLogging(this.props);
            String bean1Name = bean1.whoAreYou();
            TestUtil.logTrace((String)("java:comp/env/ejb/Philosophername is '" + bean1Name + "'"));
            TestUtil.logTrace((String)"[Client] Looking up 'java:comp/env/ejb/philosopher'...");
            bean2 = (ReferencedBean)this.nctx.lookup(bean2Lookup, ReferencedBean.class);
            bean2.createNamingContext();
            bean2.initLogging(this.props);
            String bean2Name = bean2.whoAreYou();
            TestUtil.logTrace((String)("java:comp/env/ejb/philosopher name is '" + bean2Name + "'"));
            boolean bl = pass = bean1Name.equals(bean1RefName) && bean2Name.equals(bean2RefName);
            if (!pass) {
                TestUtil.logErr((String)("[Client] java:comp/env/ejb/Philosophername is '" + bean1Name + "' expected 'Voltaire'"));
                TestUtil.logErr((String)("[Client] java:comp/env/ejb/philosophername is '" + bean2Name + "' expected 'Rousseau'"));
                throw new Exception("ejb-ref casesens test failed!");
            }
        }
        catch (Exception e) {
            throw new Exception("ejb-ref casesens test failed: " + e, e);
        }
    }

    public void cleanup() throws Exception {
        this.logMsg("[Client] cleanup()");
    }
}

