/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.xml.xconditional.xcwo;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_xml_xcwo_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_xml_xcwo_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_xml_xcwo_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWONoWhenActionsTest.jsp")), "negativeCWONoWhenActionsTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOOtherwiseNoParentTest.jsp")), "negativeCWOOtherwiseNoParentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenBeforeOtherwiseTest.jsp")), "negativeCWOWhenBeforeOtherwiseTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenNoParentTest.jsp")), "negativeCWOWhenNoParentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenSelectFailureTest.jsp")), "negativeCWOWhenSelectFailureTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenSelectReqAttrTest.jsp")), "negativeCWOWhenSelectReqAttrTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveCWOTest.jsp")), "positiveCWOTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveCWOWhiteSpaceTest.jsp")), "positiveCWOWhiteSpaceTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveCWOTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveCWOTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveCWOTest");
        this.invoke();
    }

    @Test
    public void positiveCWOWhiteSpaceTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveCWOWhiteSpaceTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveCWOWhiteSpaceTest");
        this.invoke();
    }

    @Test
    public void negativeCWONoWhenActionsTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWONoWhenActionsTest");
        TEST_PROPS.setProperty("request", "negativeCWONoWhenActionsTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenBeforeOtherwiseTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenBeforeOtherwiseTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenBeforeOtherwiseTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenNoParentTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenNoParentTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenNoParentTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOOtherwiseNoParentTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOOtherwiseNoParentTest");
        TEST_PROPS.setProperty("request", "negativeCWOOtherwiseNoParentTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenSelectReqAttrTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenSelectReqAttrTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenSelectReqAttrTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenSelectFailureTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeCWOWhenSelectFailureTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeCWOWhenSelectFailureTest");
        this.invoke();
    }
}

