/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmsproducerqueuetests;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmsproducerqueuetests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSProducer producer = null;
    private transient JMSConsumer consumer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            TestUtil.logTrace((String)("JMSVersion=" + tmp2));
            if (!tmp2.equals("2.0")) {
                TestUtil.logErr((String)("Error: incorrect JMSVersion=" + tmp2));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            TestUtil.logTrace((String)("JMSMajorVersion=" + tmp3));
            if (tmp3 != 2) {
                TestUtil.logErr((String)("Error: incorrect JMSMajorVersion=" + tmp3));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            TestUtil.logTrace((String)("JMSMinorVersion=" + tmp4));
            if (tmp4 != 0) {
                TestUtil.logErr((String)("Error: incorrect JMSMajorVersion=" + tmp4));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            TestUtil.logTrace((String)("JMSProviderName=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            TestUtil.logTrace((String)("JMSProviderVersion=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            TestUtil.logTrace((String)("ProviderMajorVersion=" + tmp5));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            TestUtil.logTrace((String)("ProviderMinorVersion=" + tmp6));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        this.logTrace("Results: " + status[index]);
        return retcode;
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            TestUtil.logMsg((String)"Create JMSContext, JMSConsumer and JMSProducer");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            this.producer = null;
            TestUtil.logMsg((String)"Flush any messages left on Queue");
            this.tool.flushDestination();
            TestUtil.logMsg((String)"Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("cleanup failed!", e);
        }
    }

    public void sendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTest1");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest1", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest1 failed");
        }
    }

    public void sendAndRecvTest2() throws Exception {
        boolean pass = true;
        String expTextMessage = "Where are you!";
        try {
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, String)");
            this.producer.send(this.destination, expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSConsumer.receiveBody(String, long)");
            String actTextMessage = (String)this.consumer.receiveBody(String.class, this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.equals(expTextMessage)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage + ", received " + actTextMessage));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest2", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest2 failed");
        }
    }

    public void sendAndRecvTest3() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Send ObjectMessage");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage();
            StringBuffer expSb = new StringBuffer("Where are you!");
            TestUtil.logMsg((String)"Set object in ObjectMessage to a StringBuffer");
            expObjectMessage.setObject((Serializable)expSb);
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTest3");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Serializable)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Receive ObjectMessage via JMSConsumer.receiveBody(Serializable.class, long)");
            StringBuffer actSb = (StringBuffer)this.consumer.receiveBody(Serializable.class, this.timeout);
            if (actSb == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in ObjectMessage");
            if (actSb.toString().equals(expSb.toString())) {
                TestUtil.logMsg((String)"ObjectMessage is correct");
            } else {
                TestUtil.logErr((String)("ObjectMessage is incorrect expected " + expSb.toString() + ", received " + actSb.toString()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest3 failed");
        }
    }

    public void sendAndRecvTest4() throws Exception {
        boolean pass = true;
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest4");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            TestUtil.logMsg((String)"Send MapMessage via JMSProducer.send(Destination, Map<String, Object>)");
            this.producer.send(this.destination, mapMsgSend);
            TestUtil.logMsg((String)"Receive MapMessage via JMSConsumer.receiveBody(Map.class, long)");
            Map mapMsgRecv = (Map)this.consumer.receiveBody(Map.class, this.timeout);
            if (mapMsgRecv == null) {
                throw new Exception("Did not receive MapMessage");
            }
            TestUtil.logMsg((String)"Compare MapMsgSend and MapMsgRecv for equality");
            for (Map.Entry entry : mapMsgSend.entrySet()) {
                String key = (String)entry.getKey();
                TestUtil.logMsg((String)("key " + key + ": " + entry.getValue().equals(mapMsgRecv.get(key))));
                if (entry.getValue().equals(mapMsgRecv.get(key))) continue;
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"MapMessage is correct");
            } else {
                TestUtil.logErr((String)("MapMessage is incorrect expected " + mapMsgSend + ", received " + mapMsgRecv));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest4 failed");
        }
    }

    public void sendAndRecvTest5() throws Exception {
        boolean pass = true;
        String messageSend = "Where are you!";
        byte[] bytesMsgSend = messageSend.getBytes();
        try {
            TestUtil.logMsg((String)"Send BytesMessage via JMSProducer.send(Destination, byte[])");
            this.producer.send(this.destination, bytesMsgSend);
            TestUtil.logMsg((String)"Receive BytesMessage via JMSConsumer.receiveBody(byte[].class, long)");
            byte[] bytesMsgRecv = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytesMsgRecv == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            TestUtil.logMsg((String)"Compare BytesMsgSend and BytesMsgRecv for equality");
            String messageRecv = new String(bytesMsgRecv);
            if (messageRecv.equals(messageSend)) {
                TestUtil.logMsg((String)"BytesMessage is correct");
            } else {
                TestUtil.logErr((String)("BytesMessage is incorrect expected " + messageRecv + ", received " + messageSend));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest5", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest5 failed");
        }
    }

    public void sendAndRecvMsgsOfEachMsgTypeTest() throws Exception {
        boolean pass = true;
        try {
            StringBuffer sb2;
            TestUtil.logMsg((String)"Send Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                TestUtil.logErr((String)"Did not receive Message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in Message");
                if (msgRecv.getBooleanProperty("booleanProperty")) {
                    TestUtil.logMsg((String)"booleanproperty is correct");
                } else {
                    TestUtil.logMsg((String)"booleanproperty is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send(this.destination, (Message)bMsg);
            deliveryTime = bMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive BytesMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            deliveryTime = mMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.context.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)oMsg);
            deliveryTime = oMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive ObjectMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in ObjectMessage");
                sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    TestUtil.logMsg((String)"objectvalue is correct");
                } else {
                    TestUtil.logErr((String)"objectvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage passing object as param");
            oMsg = this.context.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)oMsg);
            deliveryTime = oMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive ObjectMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in ObjectMessage");
                sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    TestUtil.logMsg((String)"objectvalue is correct");
                } else {
                    TestUtil.logErr((String)"objectvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            deliveryTime = sMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive StreamMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    TestUtil.logMsg((String)"booleanvalue is correct");
                } else {
                    TestUtil.logMsg((String)"booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send TextMessage");
            TextMessage tMsg = this.context.createTextMessage();
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            tMsg.setText("Hello There!");
            this.producer.send(this.destination, (Message)tMsg);
            deliveryTime = tMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (tMsgRecv.getText().equals("Hello There!")) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)"TextMessage is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send TextMessage");
            tMsg = this.context.createTextMessage("Where are you!");
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)tMsg);
            deliveryTime = tMsg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (tMsgRecv.getText().equals("Where are you!")) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)"TextMessage is incorrect");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeTest failed");
        }
    }

    public void setGetDeliveryModeTest() throws Exception {
        int actDeliveryMode;
        int expDeliveryMode;
        boolean pass = true;
        try {
            expDeliveryMode = 2;
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDeliveryModeTest");
        }
        try {
            expDeliveryMode = 1;
            TestUtil.logMsg((String)("Calling setDeliveryMode(" + expDeliveryMode + ")"));
            this.producer.setDeliveryMode(expDeliveryMode);
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("setGetDeliveryModeTest failed");
        }
    }

    public void setGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            expDeliveryDelay = 0L;
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            TestUtil.logMsg((String)("Calling setDeliveryDelay(" + expDeliveryDelay + ")"));
            this.producer.setDeliveryDelay(expDeliveryDelay);
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("setGetDeliveryDelayTest failed");
        }
    }

    public void setGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            expDisableMessageID = true;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("setGetDisableMessageIDTest failed");
        }
    }

    public void setGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            expDisableMessageTimestamp = true;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("setGetDisableMessageTimestampTest failed");
        }
    }

    public void setGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            int expPriority = 4;
            TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority + " to be returned"));
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                TestUtil.logMsg((String)("Calling setPriority(" + expPriority[i] + ")"));
                this.producer.setPriority(expPriority[i]);
                TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority[i] + " to be returned"));
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority[i]));
                pass = false;
                continue;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new Exception("setGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("setGetPriorityTest failed");
        }
    }

    public void setGetTimeToLiveTest() throws Exception {
        boolean pass = true;
        try {
            long expTimeToLive = 0L;
            TestUtil.logMsg((String)("Calling getTimeToLive and expect " + expTimeToLive + " to be returned"));
            long actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                TestUtil.logErr((String)("getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive));
                pass = false;
            }
            expTimeToLive = 1000L;
            TestUtil.logMsg((String)("Calling setTimeToLive(" + expTimeToLive + ")"));
            this.producer.setTimeToLive(expTimeToLive);
            TestUtil.logMsg((String)("Calling getTimeToLive and expect " + expTimeToLive + " to be returned"));
            actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                TestUtil.logErr((String)("getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setGetTimeToLiveTest");
        }
        if (!pass) {
            throw new Exception("setGetTimeToLiveTest failed");
        }
    }

    public void deliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------------------");
            TestUtil.logMsg((String)"BEGIN TEST deliveryDelayTest with DeliveryDelay=20Secs");
            TestUtil.logMsg((String)"------------------------------------------------------");
            this.producer.setDeliveryDelay(20000L);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage message = this.context.createTextMessage("This is a test!");
            TestUtil.logMsg((String)"Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "deliveryDelayTest");
            TestUtil.logMsg((String)"Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)message);
            TestUtil.logMsg((String)"Waiting 10 seconds to receive message");
            message = (TextMessage)this.consumer.receive(10000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Didn't receive message after 10 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 5 more seconds before receiving message");
                Thread.sleep(5000L);
                TestUtil.logMsg((String)"Waiting 10 more seconds to receive message");
                message = (TextMessage)this.consumer.receive(10000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 20 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Received message after 20 secs elapsed (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryMode(1);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)message);
            TestUtil.logMsg((String)"Waiting 10 seconds to receive message");
            message = (TextMessage)this.consumer.receive(10000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Didn't receive message after 10 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 5 more seconds before receiving message");
                Thread.sleep(5000L);
                TestUtil.logMsg((String)"Waiting 10 more seconds to receive message");
                message = (TextMessage)this.consumer.receive(10000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 20 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Received message after 20 secs elapsed (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"----------------------------------------------------");
            TestUtil.logMsg((String)"END TEST deliveryDelayTest with DeliveryDelay=20Secs");
            TestUtil.logMsg((String)"----------------------------------------------------");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("deliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("deliveryDelayTest failed");
        }
    }

    public void msgHdrMessageIDTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.producer.setDisableMessageID(false);
            TestUtil.logMsg((String)"Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrMessageIDTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            this.producer.send(this.destination, (Message)messageSentO);
            TestUtil.logMsg((String)"Receive ObjectMessage from Queue.");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("getJMSMessageID=" + messageReceivedO.getJMSMessageID()));
                id = messageReceivedO.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    TestUtil.logErr((String)"ObjectMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Objectessage JMSMessageID pass");
                }
            }
            TestUtil.logMsg((String)"Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            TestUtil.logMsg((String)"Receive MapMessage from Queue.");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("getJMSMessageID=" + messageReceivedM.getJMSMessageID()));
                id = messageReceivedM.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    TestUtil.logErr((String)"MapMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"MapMessage JMSMessageID pass");
                }
            }
            TestUtil.logMsg((String)"Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            TestUtil.logMsg((String)"Receive BytesMessage from Queue.");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("getJMSMessageID=" + messageReceivedB.getJMSMessageID()));
                id = messageReceivedB.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    TestUtil.logErr((String)"BytesMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"BytesMessage JMSMessageID pass");
                }
            }
            TestUtil.logMsg((String)"Send StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentS.writeString("Testing...");
            TestUtil.logMsg((String)"Sending message");
            this.producer.send(this.destination, (Message)messageSentS);
            TestUtil.logMsg((String)"Receive StreamMessage from Queue.");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("getJMSMessageID=" + messageReceivedS.getJMSMessageID()));
                id = messageReceivedS.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    TestUtil.logErr((String)"StreamMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"StreamMessage JMSMessageID pass");
                }
            }
            TestUtil.logMsg((String)"Send TextMessage to Queue");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            this.producer.send(this.destination, (Message)messageSent);
            TestUtil.logMsg((String)"Receive TextMessage from Queue.");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("getJMSMessageID=" + messageReceived.getJMSMessageID()));
                id = messageReceived.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    TestUtil.logErr((String)"TextMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"TextMessage JMSMessageID pass");
                }
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrMessageIDTest");
        }
    }

    public void msgHdrTimeStampTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentS = null;
            BytesMessage messageSentB = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            this.producer.setDisableMessageTimestamp(false);
            TestUtil.logMsg((String)"Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrTimeStampTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentO);
            long timeAfterSend = System.currentTimeMillis();
            TestUtil.logMsg((String)("getJMSTimestamp=" + messageSentO.getJMSTimestamp()));
            TestUtil.logMsg((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logMsg((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= messageSentO.getJMSTimestamp() && timeAfterSend >= messageSentO.getJMSTimestamp()) {
                TestUtil.logMsg((String)"ObjectMessage JMSTimeStamp pass");
            } else {
                TestUtil.logErr((String)"ObjectMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentM.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logMsg((String)("getJMSTimestamp=" + messageSentM.getJMSTimestamp()));
            TestUtil.logMsg((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logMsg((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= messageSentM.getJMSTimestamp() && timeAfterSend >= messageSentM.getJMSTimestamp()) {
                TestUtil.logMsg((String)"MapMessage JMSTimeStamp pass");
            } else {
                TestUtil.logErr((String)"MapMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            TestUtil.logMsg((String)"Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentB.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logMsg((String)("getJMSTimestamp=" + messageSentB.getJMSTimestamp()));
            TestUtil.logMsg((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logMsg((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= messageSentB.getJMSTimestamp() && timeAfterSend >= messageSentB.getJMSTimestamp()) {
                TestUtil.logMsg((String)"BytesMessage JMSTimeStamp pass");
            } else {
                TestUtil.logErr((String)"BytesMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            TestUtil.logMsg((String)"Send StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentS.writeString("Testing...");
            TestUtil.logMsg((String)"Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logMsg((String)("getJMSTimestamp=" + messageSentS.getJMSTimestamp()));
            TestUtil.logMsg((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logMsg((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= messageSentS.getJMSTimestamp() && timeAfterSend >= messageSentS.getJMSTimestamp()) {
                TestUtil.logMsg((String)"StreamMessage JMSTimeStamp pass");
            } else {
                TestUtil.logErr((String)"StreamMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            TestUtil.logMsg((String)"Send TextMessage to Queue");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage to Queue");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logMsg((String)("getJMSTimestamp=" + messageSent.getJMSTimestamp()));
            TestUtil.logMsg((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logMsg((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                TestUtil.logMsg((String)"TextMessage JMSTimeStamp pass");
            } else {
                TestUtil.logErr((String)"TextMessage invalid JMSTimeStamp failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrTimeStampTest");
        }
    }

    public void msgHdrJMSPriorityTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        int priority2 = 2;
        int priority4 = 4;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            TestUtil.logMsg((String)"Setting priority to 2");
            this.producer.setPriority(priority2);
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            TestUtil.logMsg((String)"JMSPriority test - Send a TextMessage to Queue");
            this.producer.send(this.destination, (Message)messageSent);
            TestUtil.logMsg((String)"JMSPriority test - Recv a TextMessage from Queue");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("JMSPriority is " + messageReceived.getJMSPriority()));
                if (messageReceived.getJMSPriority() == priority2) {
                    TestUtil.logMsg((String)"TextMessage JMSPriority passed");
                } else {
                    TestUtil.logErr((String)"TextMessage JMSPriority failed");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"JMSPriority test - Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSPriorityTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            this.producer.send(this.destination, (Message)messageSentO);
            TestUtil.logMsg((String)"JMSPriority test - Recv a ObjectMessage from Queue");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("JMSPriority is " + messageReceivedO.getJMSPriority()));
                if (messageReceivedO.getJMSPriority() == priority2) {
                    TestUtil.logMsg((String)"ObjectMessage JMSPriority passed");
                } else {
                    TestUtil.logErr((String)"ObjectMessage JMSPriority failed");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"JMSPriority test - Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            TestUtil.logMsg((String)"JMSPriority test - Recv a MapMessage from Queue");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("JMSPriority is " + messageReceivedM.getJMSPriority()));
                if (messageReceivedM.getJMSPriority() == priority2) {
                    TestUtil.logMsg((String)"MapMessage JMSPriority passed");
                } else {
                    TestUtil.logErr((String)"MapMessage JMSPriority failed");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Setting priority to 4");
            this.producer.setPriority(priority4);
            TestUtil.logMsg((String)"JMSPriority test - Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            TestUtil.logMsg((String)"JMSPriority test - Recv a BytesMessage from Queue");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("JMSPriority is " + messageReceivedB.getJMSPriority()));
                if (messageReceivedB.getJMSPriority() == priority4) {
                    TestUtil.logMsg((String)"BytesMessage JMSPriority passed");
                } else {
                    TestUtil.logErr((String)"BytesMessage JMSPriority failed");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"JMSPriority test - Send a StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            TestUtil.logMsg((String)"JMSPriority test - Recv a StreamMessage from Queue");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)("JMSPriority is " + messageReceivedS.getJMSPriority()));
                if (messageReceivedS.getJMSPriority() == priority4) {
                    TestUtil.logMsg((String)"StreamMessage JMSPriority passed");
                } else {
                    TestUtil.logErr((String)"StreamMessage JMSPriority failed");
                    pass = false;
                }
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSPriorityTest");
        }
    }

    public void msgHdrJMSExpirationTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        long timeToLive = 5000L;
        String testName = "msgHdrJMSExpirationTest";
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            TestUtil.logMsg((String)"JMSExpiration test - Send a TextMessage (timeToLive is forever)");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSent);
            TestUtil.logMsg((String)"JMSExpiration test - Recv a TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceived.getJMSExpiration() != forever) {
                TestUtil.logErr((String)"TextMessage JMSExpiration failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a TextMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            long exp = messageSent.getJMSExpiration();
            TestUtil.logMsg((String)("JMSExpiration is set to=" + exp));
            TestUtil.logMsg((String)("Time before send=" + timeBeforeSend));
            TestUtil.logMsg((String)("Time after send=" + timeAfterSend));
            TestUtil.logMsg((String)("Time to Live =" + timeToLive));
            TestUtil.logMsg((String)"JMSExpiration test - Recv a TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceived.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("TextMessage failed: JMSExpiration didn't set correctly = " + messageReceived.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a ObjectMessage (timeToLive is forever)");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSExpirationTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentO);
            TestUtil.logMsg((String)"JMSExpiration test - Recv a ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedO.getJMSExpiration() != forever) {
                TestUtil.logMsg((String)"ObjectMessage JMSExpiration failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"ObjectMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a ObjectMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentO);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentO.getJMSExpiration();
            TestUtil.logMsg((String)("JMSExpiration is set to=" + exp));
            TestUtil.logMsg((String)("Time before send=" + timeBeforeSend));
            TestUtil.logMsg((String)("Time after send=" + timeAfterSend));
            TestUtil.logMsg((String)("Time to Live =" + timeToLive));
            TestUtil.logMsg((String)"JMSExpiration test - Recv a ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedO.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("ObjectMessage failed: JMSExpiration didn't set correctly = " + messageReceivedO.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            } else {
                TestUtil.logMsg((String)"ObjectMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a MapMessage (timeToLive is forever)");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentM);
            TestUtil.logMsg((String)"JMSExpiration test - Recv a MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedM.getJMSExpiration() != forever) {
                TestUtil.logMsg((String)"MapMessage JMSExpiration failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"MapMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a MapMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentM.getJMSExpiration();
            TestUtil.logMsg((String)("JMSExpiration is set to=" + exp));
            TestUtil.logMsg((String)("Time before send=" + timeBeforeSend));
            TestUtil.logMsg((String)("Time after send=" + timeAfterSend));
            TestUtil.logMsg((String)("Time to Live =" + timeToLive));
            TestUtil.logMsg((String)"JMSExpiration test - Recv a MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedM.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("MapMessage failed: JMSExpiration didn't set correctly = " + messageReceivedM.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            } else {
                TestUtil.logMsg((String)"MapMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a Bytesessage (timeToLive is forever)");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentB);
            TestUtil.logMsg((String)"JMSExpiration test - Recv a BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedB.getJMSExpiration() != forever) {
                TestUtil.logMsg((String)"BytesMessage JMSExpiration failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"BytesMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a Bytesessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentB.getJMSExpiration();
            TestUtil.logMsg((String)("JMSExpiration is set to=" + exp));
            TestUtil.logMsg((String)("Time before send=" + timeBeforeSend));
            TestUtil.logMsg((String)("Time after send=" + timeAfterSend));
            TestUtil.logMsg((String)("Time to Live =" + timeToLive));
            TestUtil.logMsg((String)"JMSExpiration test - Recv a BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedB.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("BytesMessage failed: JMSExpiration didn't set correctly = " + messageReceivedB.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            } else {
                TestUtil.logMsg((String)"BytesMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a Streamessage (timeToLive is forever)");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentS);
            TestUtil.logMsg((String)"JMSExpiration test - Recv a StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedS.getJMSExpiration() != forever) {
                TestUtil.logMsg((String)"StreamMessage JMSExpiration failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"StreamMessage JMSExpiration passed");
            }
            TestUtil.logMsg((String)"JMSExpiration test - Send a StreamMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentS.getJMSExpiration();
            TestUtil.logMsg((String)("JMSExpiration is set to=" + exp));
            TestUtil.logMsg((String)("Time before send=" + timeBeforeSend));
            TestUtil.logMsg((String)("Time after send=" + timeAfterSend));
            TestUtil.logMsg((String)("Time to Live =" + timeToLive));
            TestUtil.logMsg((String)"JMSExpiration test - Recv a StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                TestUtil.logErr((String)"Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedS.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("StreamMessage failed: JMSExpiration didn't set correctly = " + messageReceivedS.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            } else {
                TestUtil.logMsg((String)"StreamMessage JMSExpiration passed");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    public void msgHdrJMSDeliveryModeTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSDeliveryModeTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            TestUtil.logMsg((String)"send TextMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSent = this.context.createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSent);
            TestUtil.logMsg((String)"receive TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"TextMessage is null (unexpected)");
            } else if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logErr((String)"TextMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                TestUtil.logMsg((String)"TextMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send TextMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSent = this.context.createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSent);
            TestUtil.logMsg((String)"receive TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"TextMessage is null (unexpected)");
            } else if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                TestUtil.logErr((String)"TextMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                TestUtil.logMsg((String)"TextMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send ObjectMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSentO);
            TestUtil.logMsg((String)"receive ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                pass = false;
                TestUtil.logErr((String)"ObjectMessage is null (unexpected)");
            } else if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logErr((String)"ObjectMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                TestUtil.logMsg((String)"ObjectMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send ObjectMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSentO);
            TestUtil.logMsg((String)"receive ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                pass = false;
                TestUtil.logErr((String)"ObjectMessage is null (unexpected)");
            } else if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                TestUtil.logErr((String)"ObjectMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                TestUtil.logMsg((String)"ObjectMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send MapMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            TestUtil.logMsg((String)"receive MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                pass = false;
                TestUtil.logErr((String)"MapMessage is null (unexpected)");
            } else if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logErr((String)"MapMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                TestUtil.logMsg((String)"MapMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send MapMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            TestUtil.logMsg((String)"receive MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                pass = false;
                TestUtil.logErr((String)"MapMessage is null (unexpected)");
            } else if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                TestUtil.logErr((String)"MapMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                TestUtil.logMsg((String)"MapMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send BytesMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            TestUtil.logMsg((String)"receive BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                pass = false;
                TestUtil.logErr((String)"BytesMessage is null (unexpected)");
            } else if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logErr((String)"BytesMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                TestUtil.logMsg((String)"BytesMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send BytesMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            TestUtil.logMsg((String)"receive BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                pass = false;
                TestUtil.logErr((String)"BytesMessage is null (unexpected)");
            } else if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                TestUtil.logErr((String)"BytesMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                TestUtil.logMsg((String)"BytesMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send StreamMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            TestUtil.logMsg((String)"receive StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                pass = false;
                TestUtil.logErr((String)"StreamMessage is null (unexpected)");
            } else if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logErr((String)"StreamMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                TestUtil.logMsg((String)"StreamMessage JMSDeliveryMode passed");
            }
            TestUtil.logMsg((String)"send StreamMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            TestUtil.logMsg((String)"receive StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                pass = false;
                TestUtil.logErr((String)"StreamMessage is null (unexpected)");
            } else if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                TestUtil.logErr((String)"StreamMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                TestUtil.logMsg((String)"StreamMessage JMSDeliveryMode passed");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    public void msgHdrJMSDeliveryTimeTest() throws Exception {
        boolean pass = true;
        try {
            long JMSDeliveryTimeAfterRecv;
            long gmtTimeAfterRecv;
            long gmtTimebeforeSend = System.currentTimeMillis();
            TestUtil.logMsg((String)"---------------------------------------------------------------");
            TestUtil.logMsg((String)"BEGIN TEST msgHdrJMSDeliveryTimeTest with DeliveryDelay=20Secs");
            TestUtil.logMsg((String)"---------------------------------------------------------------");
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage messageSnd = this.context.createTextMessage("This is a test!");
            TestUtil.logMsg((String)"Set StringProperty COM_SUN_JMS_TESTNAME");
            messageSnd.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryTimeTest");
            TestUtil.logMsg((String)"Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryDelay(20000L);
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)messageSnd);
            TestUtil.logMsg((String)"Get JMSDeliveryTime after sending message");
            long deliverydelay = this.producer.getDeliveryDelay();
            long gmtTimeAfterSend = System.currentTimeMillis();
            long JMSDeliveryTimeAfterSend = messageSnd.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive message with timeout value of 21Secs");
            TextMessage messageRcv = (TextMessage)this.consumer.receive(21000L);
            if (messageRcv == null) {
                TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Get JMSDeliveryTime after receiving message");
                gmtTimeAfterRecv = System.currentTimeMillis();
                JMSDeliveryTimeAfterRecv = messageRcv.getJMSDeliveryTime();
                TestUtil.logMsg((String)"Check JMSDeliverytime");
                TestUtil.logMsg((String)("JMSDeliveryTime after send = " + JMSDeliveryTimeAfterSend));
                TestUtil.logMsg((String)("JMSDeliveryTime after receive = " + JMSDeliveryTimeAfterRecv));
                if (JMSDeliveryTimeAfterSend == JMSDeliveryTimeAfterRecv) {
                    TestUtil.logMsg((String)"JMSDeliveryTimeAfterSend = JMSDeliveryTimeAfterRecv (PASS)");
                } else {
                    TestUtil.logErr((String)"JMSDeliveryTimeAfterSend != JMSDeliveryTimeAfterRecv (FAIL)");
                    pass = false;
                }
                TestUtil.logMsg((String)("gmtTimeAfterSend after send = " + gmtTimeAfterSend));
                TestUtil.logMsg((String)("gmtTimeAfterRecv after receive = " + gmtTimeAfterRecv));
                if (gmtTimeAfterRecv >= gmtTimebeforeSend + deliverydelay) {
                    TestUtil.logMsg((String)"gmtTimeAfterRecv >= (gmtTimeAfterSend + deliverydelay) (PASS)");
                } else {
                    TestUtil.logErr((String)"gmtTimeAfterRecv < (gmtTimeAfterSend + deliverydelay) (FAIL)");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryDelay(20000L);
            this.producer.setDeliveryMode(1);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)messageSnd);
            TestUtil.logMsg((String)"Get JMSDeliveryTime after sending message");
            gmtTimeAfterSend = System.currentTimeMillis();
            JMSDeliveryTimeAfterSend = messageSnd.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Receive message with timeout value of 21Secs");
            messageRcv = (TextMessage)this.consumer.receive(21000L);
            if (messageRcv == null) {
                TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Get JMSDeliveryTime after receiving message");
                gmtTimeAfterRecv = System.currentTimeMillis();
                JMSDeliveryTimeAfterRecv = messageRcv.getJMSDeliveryTime();
                TestUtil.logMsg((String)"Check JMSDeliverytime");
                TestUtil.logMsg((String)("JMSDeliveryTime after send = " + JMSDeliveryTimeAfterSend));
                TestUtil.logMsg((String)("JMSDeliveryTime after receive = " + JMSDeliveryTimeAfterRecv));
                if (JMSDeliveryTimeAfterSend == JMSDeliveryTimeAfterRecv) {
                    TestUtil.logMsg((String)"JMSDeliveryTimeAfterSend = JMSDeliveryTimeAfterRecv (PASS)");
                } else {
                    TestUtil.logErr((String)"JMSDeliveryTimeAfterSend != JMSDeliveryTimeAfterRecv (FAIL)");
                    pass = false;
                }
                TestUtil.logMsg((String)("gmtTimeAfterSend after send = " + gmtTimeAfterSend));
                TestUtil.logMsg((String)("gmtTimeAfterRecv after receive = " + gmtTimeAfterRecv));
                if (gmtTimeAfterRecv >= gmtTimebeforeSend + deliverydelay) {
                    TestUtil.logMsg((String)"gmtTimeAfterRecv >= (gmtTimeAfterSend + deliverydelay) (PASS)");
                } else {
                    TestUtil.logErr((String)"gmtTimeAfterRecv < (gmtTimeAfterSend + deliverydelay) (FAIL)");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"-------------------------------------------------------------");
            TestUtil.logMsg((String)"END TEST msgHdrJMSDeliveryTimeTest with DeliveryDelay=20Secs");
            TestUtil.logMsg((String)"-------------------------------------------------------------");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDeliveryTimeTest", e);
        }
        if (!pass) {
            throw new Exception("msgHdrJMSDeliveryTimeTest failed");
        }
    }

    public void setGetAllPropertyTypesTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        int numPropertyNames = 16;
        try {
            this.logMsg("Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            this.logMsg("Set all JMSProducer properties");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            this.logMsg("Get all JMSProducer properties");
            if (this.producer.getBooleanProperty("TESTBOOLEAN") == bool) {
                this.logMsg("Pass: getBooleanProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTBYTE") == bValue) {
                this.logMsg("Pass: getByteProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTLONG") == nLong) {
                this.logMsg("Pass: getLongProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (this.producer.getStringProperty("TESTSTRING").equals(testString)) {
                this.logMsg("Pass: getStringProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getDoubleProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTFLOAT") == nFloat) {
                this.logMsg("Pass: getFloatProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTINT") == nInt) {
                this.logMsg("Pass: getIntProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSHORT") == nShort) {
                this.logMsg("Pass: getShortProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if ((Boolean)this.producer.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                this.logMsg("Pass: getObjectProperty returned correct Boolean value");
            } else {
                this.logMsg("Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)this.producer.getObjectProperty("OBJTESTBYTE") == bValue) {
                this.logMsg("Pass: getObjectProperty returned correct Byte value");
            } else {
                this.logMsg("Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)this.producer.getObjectProperty("OBJTESTLONG") == nLong) {
                this.logMsg("Pass: getObjectProperty returned correct Long value");
            } else {
                this.logMsg("Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)this.producer.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                this.logMsg("Pass: getObjectProperty returned correct String value");
            } else {
                this.logMsg("Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)this.producer.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getObjectProperty returned correct Double value");
            } else {
                this.logMsg("Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)this.producer.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                this.logMsg("Pass: getObjectProperty returned correct Float value");
            } else {
                this.logMsg("Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)this.producer.getObjectProperty("OBJTESTINT") == nInt) {
                this.logMsg("Pass: getObjectProperty returned correct Integer value");
            } else {
                this.logMsg("Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)this.producer.getObjectProperty("OBJTESTSHORT") == nShort) {
                this.logMsg("Pass: getObjectProperty returned correct Short value");
            } else {
                this.logMsg("Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            this.logMsg("Now check all property names returned by JMSProducer.getPropertyNames()");
            int i = 0;
            Set propNames = this.producer.getPropertyNames();
            Iterator iterator = propNames.iterator();
            do {
                String tmp;
                if (!(tmp = (String)iterator.next()).startsWith("JMS")) {
                    ++i;
                    if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN") || tmp.equals("OBJTESTBYTE") || tmp.equals("OBJTESTINT") || tmp.equals("OBJTESTSHORT") || tmp.equals("OBJTESTFLOAT") || tmp.equals("OBJTESTDOUBLE") || tmp.equals("OBJTESTSTRING") || tmp.equals("OBJTESTLONG")) {
                        this.logMsg("Producer Property set by client: " + tmp);
                        continue;
                    }
                    this.logErr("Producer Property not set by client: " + tmp);
                    pass = false;
                    continue;
                }
                this.logMsg("JMSProperty Name is: " + tmp);
            } while (iterator.hasNext());
            if (i == numPropertyNames) {
                this.logMsg("Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                this.logMsg("Fail: expected " + numPropertyNames + " property names, but got " + i);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAllPropertyTypesTest");
        }
        if (!pass) {
            throw new Exception("setGetAllPropertyTypesTest failed");
        }
    }

    public void setGetAllHeaderTypesTest() throws Exception {
        boolean pass = true;
        try {
            this.logMsg("Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            try {
                this.logMsg("Set JMSProducer message header JMSCorrelationID as bytes");
                byte[] cid = "TestCorrelationID".getBytes();
                this.producer.setJMSCorrelationIDAsBytes(cid);
                this.logMsg("Get JMSProducer message header JMSCorrelationID as bytes");
                cid = this.producer.getJMSCorrelationIDAsBytes();
                String cidString = new String(cid);
                if (cid == null) {
                    this.logMsg("Fail: getJMSCorrelationID returned null");
                    pass = false;
                } else if (cidString.equals("TestCorrelationID")) {
                    this.logMsg("Pass: getJMSCorrelationID returned correct value");
                } else {
                    this.logMsg("Fail: getJMSCorrelationID returned incorrect value, got: " + cidString + " expected: TestCorrelationID");
                    pass = false;
                }
            }
            catch (UnsupportedOperationException e) {
                this.logMsg("UnsupportedOperationException - no further testing.");
            }
            this.logMsg("Set all JMSProducer message headers JMSCorrelationID, JMSType, JMSReplyTo");
            this.producer.setJMSCorrelationID("TestCorrelationID");
            this.producer.setJMSType("TestMessage");
            this.producer.setJMSReplyTo(this.destination);
            this.logMsg("Get all JMSProducer message headers JMSCorrelationID, JMSType, JMSReplyTo");
            String temp = null;
            Destination tempdest = null;
            temp = this.producer.getJMSCorrelationID();
            if (temp == null) {
                this.logMsg("Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                this.logMsg("Pass: getJMSCorrelationID returned correct value");
            } else {
                this.logMsg("Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = this.producer.getJMSType();
            if (temp == null) {
                this.logMsg("Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                this.logMsg("Pass: getJMSType returned correct value");
            } else {
                this.logMsg("Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = this.producer.getJMSReplyTo();
            if (tempdest == null) {
                this.logMsg("Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                this.logMsg("Pass: getJMSReplyTo returned correct value");
            } else {
                this.logMsg("Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAllHeaderTypesTest");
        }
        if (!pass) {
            throw new Exception("setGetAllHeaderTypesTest failed");
        }
    }

    public void msgPropertiesTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        Object jmsxDefined = null;
        int numPropertyNames = 18;
        String testMessageBody = "Testing...";
        String message = "Where are you!";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.logMsg("Set primitive property types on JMSProducer");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            this.logMsg("Set Object property types on JMSProducer");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context.createTextMessage(message);
            this.logMsg("messageSent=" + messageSent.getText());
            TestUtil.logMsg((String)"Set some values in TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            this.producer.send(this.destination, (Message)messageSent);
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            this.logMsg("messageReceived=" + messageReceived.getText());
            int i = 0;
            this.logMsg("Retrieve and verify correct # of properties set");
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp = (String)propertyNames.nextElement();
                this.logMsg("Property Name is: " + tmp);
                if (tmp.indexOf("JMS") != 0) {
                    ++i;
                    continue;
                }
                if (!tmp.equals("JMSXDeliveryCount")) continue;
                ++i;
            } while (propertyNames.hasMoreElements());
            if (i == numPropertyNames) {
                this.logMsg("Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                this.logMsg("Fail: expected " + numPropertyNames + " property names, but got " + i);
                pass = false;
            }
            this.logMsg("Retrieve and verify that JMSProducer properties were set correctly");
            this.logMsg("Get properties for boolean, byte, short, int, long, float, double, and String.");
            if (this.producer.getBooleanProperty("TESTBOOLEAN") == bool) {
                this.logMsg("Pass: getBooleanProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTBYTE") == bValue) {
                this.logMsg("Pass: getByteProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTLONG") == nLong) {
                this.logMsg("Pass: getLongProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (this.producer.getStringProperty("TESTSTRING").equals(testString)) {
                this.logMsg("Pass: getStringProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getDoubleProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTFLOAT") == nFloat) {
                this.logMsg("Pass: getFloatProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTINT") == nInt) {
                this.logMsg("Pass: getIntProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSHORT") == nShort) {
                this.logMsg("Pass: getShortProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            this.logMsg("Get properties for Boolean, Byte, Short, Integer, Long, Float, Double, String.");
            if ((Boolean)this.producer.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                this.logMsg("Pass: getObjectProperty returned correct Boolean value");
            } else {
                this.logMsg("Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)this.producer.getObjectProperty("OBJTESTBYTE") == bValue) {
                this.logMsg("Pass: getObjectProperty returned correct Byte value");
            } else {
                this.logMsg("Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)this.producer.getObjectProperty("OBJTESTLONG") == nLong) {
                this.logMsg("Pass: getObjectProperty returned correct Long value");
            } else {
                this.logMsg("Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)this.producer.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                this.logMsg("Pass: getObjectProperty returned correct String value");
            } else {
                this.logMsg("Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)this.producer.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getObjectProperty returned correct Double value");
            } else {
                this.logMsg("Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)this.producer.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                this.logMsg("Pass: getObjectProperty returned correct Float value");
            } else {
                this.logMsg("Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)this.producer.getObjectProperty("OBJTESTINT") == nInt) {
                this.logMsg("Pass: getObjectProperty returned correct Integer value");
            } else {
                this.logMsg("Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)this.producer.getObjectProperty("OBJTESTSHORT") == nShort) {
                this.logMsg("Pass: getObjectProperty returned correct Short value");
            } else {
                this.logMsg("Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            this.logMsg("Set message headers JMSCorrelationID, JMSType, JMSReplyTo on JMSProducer");
            this.producer.setJMSCorrelationID("TestCorrelationID");
            this.producer.setJMSType("TestMessage");
            this.producer.setJMSReplyTo(this.destination);
            String temp = null;
            Destination tempdest = null;
            temp = this.producer.getJMSCorrelationID();
            if (temp == null) {
                this.logMsg("Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                this.logMsg("Pass: getJMSCorrelationID returned correct value");
            } else {
                this.logMsg("Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = this.producer.getJMSType();
            if (temp == null) {
                this.logMsg("Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                this.logMsg("Pass: getJMSType returned correct value");
            } else {
                this.logMsg("Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = this.producer.getJMSReplyTo();
            if (tempdest == null) {
                this.logMsg("Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                this.logMsg("Pass: getJMSReplyTo returned correct value");
            } else {
                this.logMsg("Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
            this.logMsg("Create a TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            this.logMsg("Send the TextMessage");
            this.producer.send(this.destination, (Message)messageSent);
            this.logMsg("messageSent=" + messageSent.getText());
            this.logMsg("Receive the TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            this.logMsg("messageReceived=" + messageReceived.getText());
            this.logMsg("Retrieve and verify that TextMessage message properties were set correctly");
            if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                this.logMsg("Pass: getBooleanProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                this.logMsg("Pass: getByteProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                this.logMsg("Pass: getLongProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                this.logMsg("Pass: getStringProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getDoubleProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                this.logMsg("Pass: getFloatProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTINT") == nInt) {
                this.logMsg("Pass: getIntProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                this.logMsg("Pass: getShortProperty returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("JMSXDeliveryCount") >= 1) {
                this.logMsg("Pass: getIntProperty(JMSXDeliveryCount) returned correct value");
            } else {
                this.logMsg("Fail: incorrect value returned from getIntProperty(JMSXDeliveryCount)");
                pass = false;
            }
            if ((Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                this.logMsg("Pass: getObjectProperty returned correct Boolean value");
            } else {
                this.logMsg("Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)messageReceived.getObjectProperty("OBJTESTBYTE") == bValue) {
                this.logMsg("Pass: getObjectProperty returned correct Byte value");
            } else {
                this.logMsg("Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)messageReceived.getObjectProperty("OBJTESTLONG") == nLong) {
                this.logMsg("Pass: getObjectProperty returned correct Long value");
            } else {
                this.logMsg("Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)messageReceived.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                this.logMsg("Pass: getObjectProperty returned correct String value");
            } else {
                this.logMsg("Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)messageReceived.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                this.logMsg("Pass: getObjectProperty returned correct Double value");
            } else {
                this.logMsg("Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)messageReceived.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                this.logMsg("Pass: getObjectProperty returned correct Float value");
            } else {
                this.logMsg("Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)messageReceived.getObjectProperty("OBJTESTINT") == nInt) {
                this.logMsg("Pass: getObjectProperty returned correct Integer value");
            } else {
                this.logMsg("Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)messageReceived.getObjectProperty("OBJTESTSHORT") == nShort) {
                this.logMsg("Pass: getObjectProperty returned correct Short value");
            } else {
                this.logMsg("Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            temp = messageReceived.getJMSCorrelationID();
            if (temp == null) {
                this.logMsg("Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                this.logMsg("Pass: getJMSCorrelationID returned correct value");
            } else {
                this.logMsg("Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = messageReceived.getJMSType();
            if (temp == null) {
                this.logMsg("Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                this.logMsg("Pass: getJMSType returned correct value");
            } else {
                this.logMsg("Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = messageReceived.getJMSReplyTo();
            if (tempdest == null) {
                this.logMsg("Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                this.logMsg("Pass: getJMSReplyTo returned correct value");
            } else {
                this.logMsg("Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
            try {
                boolean b = this.producer.getBooleanProperty("TESTDUMMY");
                if (b) {
                    this.logMsg("Fail: should have received false for getBooleanProperty");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                byte value = this.producer.getByteProperty("TESTDUMMY");
                this.logMsg("Fail: NumberFormatException should have occurred for getByteProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logMsg("Pass: NumberFormatException as expected ");
            }
            try {
                short value = this.producer.getShortProperty("TESTDUMMY");
                this.logMsg("Fail: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logMsg("Pass: NumberFormatException as expected ");
            }
            try {
                int value = this.producer.getIntProperty("TESTDUMMY");
                this.logMsg("Fail: NumberFormatException should have occurred for getIntProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logMsg("Pass: NumberFormatException as expected ");
            }
            try {
                long value = this.producer.getLongProperty("TESTDUMMY");
                this.logMsg("Fail: NumberFormatException should have occurred for getLongProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logMsg("Pass: NumberFormatException as expected ");
            }
            try {
                float value = this.producer.getFloatProperty("TESTDUMMY");
                this.logMsg("Fail: NullPointerException should have occurred for getFloatProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                this.logMsg("Pass: NullPointerException as expected ");
            }
            try {
                double value = this.producer.getDoubleProperty("TESTDUMMY");
                this.logMsg("Fail: NullPointerException should have occurred for getDoubleProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                this.logMsg("Pass: NullPointerException as expected ");
            }
            this.producer.clearProperties();
            Long aLong = (Long)this.producer.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                this.logMsg("Pass: property was cleared");
            } else {
                this.logMsg("Fail: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                short aShort = this.producer.getShortProperty("TESTSHORT");
                this.logMsg("Fail: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logMsg("Pass: NumberFormatException as expected ");
            }
            Set propNames = this.producer.getPropertyNames();
            Iterator iterator = propNames.iterator();
            boolean hasElements = iterator.hasNext();
            if (hasElements) {
                this.logMsg("Fail: JMSProducer.getPropertyName() has properties (unexpected)");
                pass = false;
            } else {
                this.logMsg("Pass: JMSProducer.getPropertyName() has no properties (expected)");
            }
            try {
                ConnectionMetaData data = this.context.getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    this.logMsg("Fail: no JMSX property names were returned!");
                    this.logMsg("expected JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount at a miniumum");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        this.logMsg(propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq") && !propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        this.logMsg("Pass:");
                    } else {
                        this.logMsg("Fail: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                this.logMsg("Fail: unexpected exception: " + ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgPropertiesTest failed");
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: " + e);
            e.printStackTrace();
            throw new Exception("msgPropertiesTest failed");
        }
    }

    public void msgPropertiesConversionTests() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            Object messageSent = null;
            Object messageReceived = null;
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSTRINGTRUE", "true");
            this.producer.setProperty("TESTSTRINGFALSE", "false");
            this.producer.setProperty("TESTSTRING1", "1");
            String myBool = this.producer.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                this.logMsg("Pass: conversion from boolean to string - ok");
            } else {
                this.logMsg("Fail: conversion from boolean to string failed");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTBOOLEAN");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = this.producer.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                this.logMsg("Pass: conversion from byte to string - ok");
            } else {
                this.logMsg("Fail: conversion from byte to string failed");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTBYTE") == bValue) {
                this.logMsg("Pass: conversion from byte to short - ok");
            } else {
                this.logMsg("Fail: conversion from byte to short failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTBYTE") == bValue) {
                this.logMsg("Pass: conversion from byte to int - ok");
            } else {
                this.logMsg("Fail: conversion from byte to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTBYTE") == (long)bValue) {
                this.logMsg("Pass: conversion from byte to long - ok");
            } else {
                this.logMsg("Fail: conversion from byte to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTBYTE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTBYTE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTBYTE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = this.producer.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                this.logMsg("Pass: conversion from short to string - ok");
            } else {
                this.logMsg("Fail: conversion from short to string failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTSHORT") == nShort) {
                this.logMsg("Pass: conversion from short to int - ok");
            } else {
                this.logMsg("Fail: conversion from short to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTSHORT") == (long)nShort) {
                this.logMsg("Pass: conversion from short to long - ok");
            } else {
                this.logMsg("Fail: conversion from short to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTSHORT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTSHORT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTSHORT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTSHORT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(this.producer.getStringProperty("TESTINT")) == nInt) {
                this.logMsg("Pass: conversion from int to string - ok");
            } else {
                this.logMsg("Fail: conversion from int to string failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTINT") == (long)nInt) {
                this.logMsg("Pass: conversion from int to long - ok");
            } else {
                this.logMsg("Fail: conversion from int to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTINT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTINT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTINT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected -- int to short ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception ");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTINT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTINT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(this.producer.getStringProperty("TESTLONG")) == nLong) {
                this.logMsg("Pass: conversion from long to string - ok");
            } else {
                this.logMsg("Fail: conversion from long to string failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTLONG");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(this.producer.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                this.logMsg("Pass: conversion from float to string - ok");
            } else {
                this.logMsg("Fail: conversion from float to string failed");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                this.logMsg("Pass: conversion from long to double - ok");
            } else {
                this.logMsg("Fail: conversion from long to double failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTFLOAT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTFLOAT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTFLOAT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTFLOAT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTFLOAT");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(this.producer.getStringProperty("TESTDOUBLE")) == nDouble) {
                this.logMsg("Pass: conversion from double to string - ok");
            } else {
                this.logMsg("Fail: conversion from double to string failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTDOUBLE");
                this.logMsg("Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                this.logMsg("Fail: unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                this.logMsg("Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                this.logMsg("Fail: Caught unexpected exception: " + ee);
                this.logMsg("Fail: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (this.producer.getBooleanProperty("TESTSTRINGTRUE")) {
                this.logMsg("Pass: conversion from string to boolean - expect true - ok");
            } else {
                this.logMsg("Fail: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!this.producer.getBooleanProperty("TESTSTRINGFALSE")) {
                this.logMsg("Pass: conversion from string to boolean expect false - ok");
            } else {
                this.logMsg("Fail: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTSTRING1") == 1) {
                this.logMsg("Pass: conversion from string to byte - ok");
            } else {
                this.logMsg("Fail: conversion from string to byte failed");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSTRING1") == 1) {
                this.logMsg("Pass: conversion from string to short - ok");
            } else {
                this.logMsg("Fail: conversion from string to short failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTSTRING1") == 1) {
                this.logMsg("Pass: conversion from string to int - ok");
            } else {
                this.logMsg("Fail: conversion from string to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTSTRING1") == 1L) {
                this.logMsg("Pass: conversion from string to long - ok");
            } else {
                this.logMsg("Fail: conversion from string to long failed");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTSTRING1") == 1.0f) {
                this.logMsg("Pass: conversion from string to float - ok");
            } else {
                this.logMsg("Fail: conversion from string to float failed");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTSTRING1") == 1.0) {
                this.logMsg("Pass: conversion from string to double - ok");
            } else {
                this.logMsg("Fail: conversion from string to double failed");
                pass = false;
            }
        }
        catch (Exception e) {
            this.logMsg("Caught unexpected exception: " + e);
            throw new Exception("msgPropertiesConversionTests failed");
        }
        if (!pass) {
            throw new Exception("msgPropertiesConversionTests failed");
        }
    }

    public void msgPropertyExistTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        String testMessageBody = "Testing msgPropertyExistTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.logMsg("Create a TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            this.logMsg("Send the TextMessage");
            this.producer.send(this.destination, (Message)messageSent);
            this.logMsg("Receive the TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"messageReceived is null (unexpected)");
            } else {
                int i = 0;
                propertyNames = messageReceived.getPropertyNames();
                do {
                    String tmp;
                    if (!(tmp = (String)propertyNames.nextElement()).startsWith("JMS")) {
                        ++i;
                        if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN") || tmp.equals("COM_SUN_JMS_TESTNAME")) {
                            this.logMsg("Application Property set by client is: " + tmp);
                            if (!messageReceived.propertyExists(tmp)) {
                                pass = messageReceived.propertyExists(tmp);
                                this.logErr("Positive propertyExists test failed for " + tmp);
                                continue;
                            }
                            if (!messageReceived.propertyExists(tmp + "1")) continue;
                            pass = false;
                            this.logErr("Negative propertyExists test failed for " + tmp + "1");
                            continue;
                        }
                        this.logErr("Appclication Property not set by client: " + tmp);
                        pass = false;
                        continue;
                    }
                    this.logMsg("JMSProperty Name is: " + tmp);
                } while (propertyNames.hasMoreElements());
            }
            if (!pass) {
                throw new Exception("msgPropertyExistTest failed");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            throw new Exception("msgPropertyExistTest failed");
        }
    }

    public void msgJMSXPropertiesTest() throws Exception {
        boolean pass;
        block25: {
            pass = true;
            String message = "Testing msgJMSXPropertiesTest";
            int seq = 123450;
            String id = "msgJMSXPropertiesTest";
            try {
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set StringProperty COM_SUN_JMS_TESTNAME");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgJMSXPropertiesTest");
                TestUtil.logMsg((String)"Set JMSXGroupSeq and JMSXGroupSeq");
                expTextMessage.setStringProperty("JMSXGroupID", id);
                expTextMessage.setIntProperty("JMSXGroupSeq", seq);
                TestUtil.logMsg((String)"Send the TextMessage");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logMsg((String)"Receive the TextMessage");
                TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
                TestUtil.logMsg((String)"Verify the value in TextMessage");
                if (actTextMessage == null) {
                    throw new Exception("Did not receive TextMessage");
                }
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
                TestUtil.logMsg((String)"Verify properties JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount in TextMessage");
                if (actTextMessage.propertyExists("JMSXGroupID")) {
                    if (actTextMessage.getStringProperty("JMSXGroupID").equals(id)) {
                        this.logMsg("Pass: getStringProperty(JMSXGroupID) returned correct value");
                    } else {
                        this.logErr("Fail: incorrect value returned from getStringProperty(JMSXGroupID)");
                        pass = false;
                    }
                } else {
                    this.logErr("Fail: TextMessage does not contain expected JMSXGroupID property");
                    pass = false;
                }
                if (actTextMessage.propertyExists("JMSXGroupSeq")) {
                    if (actTextMessage.getIntProperty("JMSXGroupSeq") == seq) {
                        this.logMsg("Pass: getIntProperty(JMSXGroupSeq) returned correct value");
                    } else {
                        this.logErr("Fail: incorrect value returned from getIntProperty(JMSXGroupSeq)");
                        pass = false;
                    }
                } else {
                    this.logErr("Fail: TextMessage does not contain expected JMSXGroupSeq property");
                    pass = false;
                }
                if (actTextMessage.propertyExists("JMSXDeliveryCount")) {
                    if (actTextMessage.getIntProperty("JMSXDeliveryCount") == 1) {
                        this.logMsg("Pass: getIntProperty(JMSXDeliveryCount) returned correct value");
                    } else {
                        this.logErr("Fail: incorrect value returned from getIntProperty(JMSXDeliveryCount)");
                        pass = false;
                    }
                } else {
                    this.logErr("Fail: TextMessage does not contain expected JMSXDeliveryCount property");
                    pass = false;
                }
                TestUtil.logMsg((String)"Verify the JMSXProperties in ConnectionMetaData");
                try {
                    TestUtil.logMsg((String)"Get ConnectionMetaData");
                    ConnectionMetaData data = this.context.getMetaData();
                    TestUtil.logMsg((String)"Get JMSXPropertyNames");
                    Enumeration cmd = data.getJMSXPropertyNames();
                    TestUtil.logMsg((String)"Verify that we have JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount");
                    if (cmd == null) {
                        TestUtil.logErr((String)"No JMSX property names were returned (Failed)");
                        pass = false;
                        break block25;
                    }
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        TestUtil.logTrace((String)("Found JMSX property [" + propName + "]"));
                        if (propName.equals("JMSXGroupID")) {
                            ++iCount;
                            continue;
                        }
                        if (propName.equals("JMSXGroupSeq")) {
                            ++iCount;
                            continue;
                        }
                        if (!propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 2) {
                        TestUtil.logMsg((String)"Expected JMSX property names were returned (Passed)");
                        break block25;
                    }
                    TestUtil.logErr((String)"Expected JMSX property names not returned (Failed)");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught exception: " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new Exception("msgJMSXPropertiesTest", e);
            }
        }
        if (!pass) {
            throw new Exception("msgJMSXPropertiesTest failed");
        }
    }

    public void setPropertyExceptionTests() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            this.logMsg("Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Test IllegalArgumentException from all JMSProducer setProperty() API's");
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", boolean)");
                this.producer.setProperty("", bool);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", byte)");
                this.producer.setProperty("", bValue);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", double)");
                this.producer.setProperty("", nDouble);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", float)");
                this.producer.setProperty("", nFloat);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", int)");
                this.producer.setProperty("", nInt);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", long)");
                this.producer.setProperty("", nLong);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", short)");
                this.producer.setProperty("", nShort);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", String)");
                this.producer.setProperty("", "test");
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(\"\", Object)");
                this.producer.setProperty("", (Object)nLong);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, boolean)");
                this.producer.setProperty(null, bool);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, byte)");
                this.producer.setProperty(null, bValue);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, double)");
                this.producer.setProperty(null, nDouble);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, float)");
                this.producer.setProperty(null, nFloat);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, int)");
                this.producer.setProperty(null, nInt);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, long)");
                this.producer.setProperty(null, nLong);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, short)");
                this.producer.setProperty(null, nShort);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, String)");
                this.producer.setProperty(null, "test");
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test IllegalArgumentException for setProperty(null, Object)");
                this.producer.setProperty(null, (Object)nLong);
                TestUtil.logErr((String)"Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Test MessageFormatRuntimeException for setProperty(String, Object)");
                this.producer.setProperty("name1", new ArrayList(2));
                TestUtil.logErr((String)"Fail: Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Pass: Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Fail: Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setPropertyExceptionTests");
        }
        if (!pass) {
            throw new Exception("setPropertyExceptionTests failed");
        }
    }

    public void sendExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for MessageFormatRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Message) -> expect MessageFormatRuntimeException");
                this.producer.send(this.destination, (Message)null);
                TestUtil.logErr((String)"MessageFormatRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected MessageFormatRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Map) for MessageFormatRuntimeException");
            try {
                HashMap<String, Cloneable> mp = new HashMap<String, Cloneable>();
                mp.put("1", new ArrayList(2));
                mp.put("2", new Properties());
                mp.put("2", new Properties());
                mp.put("1", new ArrayList(2));
                TestUtil.logMsg((String)"Calling send(Destination, Map) -> expect MessageFormatRuntimeException");
                this.producer.send(this.destination, mp);
                TestUtil.logErr((String)"MessageFormatRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected MessageFormatRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for MessageNotWriteableRuntimeException");
            try {
                TestUtil.logMsg((String)"Create TextMessage");
                TextMessage sendTextMessage = this.context.createTextMessage(message);
                sendTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendExceptionTests");
                TestUtil.logMsg((String)"Send TextMessage");
                this.producer.send(this.destination, (Message)sendTextMessage);
                TestUtil.logMsg((String)"Receive TextMessage");
                TextMessage recvTextMessage = (TextMessage)this.consumer.receive(this.timeout);
                if (recvTextMessage == null) {
                    TestUtil.logErr((String)"Did not receive TextMessage");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Check the value in TextMessage");
                    if (recvTextMessage.getText().equals(sendTextMessage.getText())) {
                        TestUtil.logMsg((String)"TextMessage is correct");
                    } else {
                        TestUtil.logErr((String)("TextMessage is incorrect expected " + sendTextMessage.getText() + ", received " + recvTextMessage.getText()));
                        pass = false;
                    }
                }
                TestUtil.logMsg((String)"Set a bunch of JMSProducer properties");
                this.producer.setProperty("TESTBOOLEAN", bool);
                this.producer.setProperty("TESTBYTE", bValue);
                this.producer.setProperty("TESTDOUBLE", nDouble);
                this.producer.setProperty("TESTFLOAT", nFloat);
                this.producer.setProperty("TESTINT", nInt);
                this.producer.setProperty("TESTLONG", nLong);
                this.producer.setProperty("TESTSHORT", nShort);
                this.producer.setProperty("TESTSTRING", testString);
                this.producer.setProperty("OBJTESTLONG", (Object)nLong);
                TestUtil.logMsg((String)"Using received TextMessage try and send it (expect MessageNotWriteableRuntimeException)");
                this.producer.send(this.destination, (Message)recvTextMessage);
                TestUtil.logErr((String)"MessageNotWriteableRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageNotWriteableRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageNotWriteableRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected MessageNotWriteableRuntimeException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("sendExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("sendExceptionTests failed");
        }
    }

    public void getBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Call TextMessage.getBody(String.class) to extract TextMessage as String");
            String actMessage = (String)actTextMessage.getBody(String.class);
            TestUtil.logMsg((String)"Check the value in String");
            if (actMessage.equals(message)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + message + ", received " + actMessage));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Call ObjectMessage.getBody(StringBuffer.class) to extract ObjectMessage as StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)actObjectMessage.getBody(StringBuffer.class);
            TestUtil.logMsg((String)"Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                TestUtil.logMsg((String)"ObjectMessage is correct");
            } else {
                TestUtil.logErr((String)("ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive BytesMessage");
            BytesMessage actBytesMessage = (BytesMessage)this.consumer.receive(this.timeout);
            if (actBytesMessage == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            TestUtil.logMsg((String)"Call BytesMessage.getBody(StringBuffer.class) to extract BytesMessage as byte[] array");
            byte[] bytes = (byte[])actBytesMessage.getBody(byte[].class);
            if (bytes == null) {
                TestUtil.logErr((String)"Did not receive BytesMessage");
                pass = false;
            } else {
                try {
                    DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                    TestUtil.logMsg((String)"Check the values in BytesMessage");
                    if (di.readByte() == 1) {
                        TestUtil.logMsg((String)"bytevalue is correct");
                    } else {
                        TestUtil.logMsg((String)"bytevalue is incorrect");
                        pass = false;
                    }
                    if (di.readInt() == 22) {
                        TestUtil.logMsg((String)"intvalue is correct");
                    } else {
                        TestUtil.logMsg((String)"intvalue is incorrect");
                        pass = false;
                    }
                    try {
                        byte by = di.readByte();
                    }
                    catch (EOFException e) {
                        TestUtil.logMsg((String)"Caught expected EOFException");
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)("Caught unexpected exception: " + e));
                        pass = false;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive MapMessage");
            MapMessage actMapMessage = (MapMessage)this.consumer.receive(this.timeout);
            if (actMapMessage == null) {
                throw new Exception("Did not receive MapMessage");
            }
            TestUtil.logMsg((String)"Call MapMessage.getBody(Map.class) to extract MapMessage as a Map object");
            Map map = (Map)actMapMessage.getBody(Map.class);
            if (map == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                TestUtil.logMsg((String)("map.size()=" + map.size()));
                if (map.size() != 2) {
                    TestUtil.logErr((String)("Map size is " + map.size() + ", expected 2"));
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("getBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("getBodyTests failed");
        }
    }

    public void getBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Call TextMessage.getBody(Boolean.class) to extract TextMessage as Boolean (expect MessageFormatException)");
            try {
                Boolean myBool = (Boolean)actTextMessage.getBody(Boolean.class);
                TestUtil.logErr((String)"Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logMsg((String)"Caught correct MessageFormatException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Call ObjectMessage.getBody(HashMap.class) to extract ObjectMessage as HashMap (expect MessageFormatException");
            try {
                HashMap hmap = (HashMap)actObjectMessage.getBody(HashMap.class);
                TestUtil.logErr((String)"Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logMsg((String)"Caught correct MessageFormatException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create StreamMessage");
            StreamMessage expStreamMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            expStreamMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            expStreamMsg.writeBoolean(true);
            expStreamMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the StreamMessage");
            this.producer.send(this.destination, (Message)expStreamMsg);
            StreamMessage actStreamMsg = (StreamMessage)this.consumer.receive(this.timeout);
            if (actStreamMsg == null) {
                throw new Exception("Did not receive StreamMessage");
            }
            TestUtil.logMsg((String)"Call StreamMessage.getBody(HashMap.class) to extract StreamMessage as HashMap (expect MessageFormatException");
            try {
                HashMap hmap = (HashMap)actStreamMsg.getBody(HashMap.class);
                TestUtil.logErr((String)"Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logMsg((String)"Caught correct MessageFormatException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"BytesMessage is in write-only mode");
            TestUtil.logMsg((String)"Call BytesMessage.getBody(StringBuffer.class) to receive BytesMessage as StringBuffer(expect MessageFormatException)");
            try {
                bMsg.getBody(StringBuffer.class);
                TestUtil.logErr((String)"Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logMsg((String)"Caught correct MessageFormatException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            BytesMessage actBytesMsg = (BytesMessage)this.consumer.receive(this.timeout);
            try {
                actBytesMsg.getBody(StringBuffer.class);
                TestUtil.logErr((String)"Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                TestUtil.logMsg((String)"Caught correct MessageFormatException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("getBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("getBodyExceptionTests failed");
        }
    }

    public void isBodyAssignableToTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "isBodyAssignableToTest");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            try {
                TestUtil.logMsg((String)"Call TextMessage.isBodyAssignableTo(Boolean.class) (expect false)");
                boolean b = actTextMessage.isBodyAssignableTo(Boolean.class);
                if (b) {
                    TestUtil.logErr((String)"Expected false got true");
                    pass = false;
                }
                TestUtil.logMsg((String)"Call TextMessage.isBodyAssignableTo(String.class) (expect true)");
                b = actTextMessage.isBodyAssignableTo(String.class);
                if (!b) {
                    TestUtil.logErr((String)"Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "isBodyAssignableToTest");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            try {
                TestUtil.logMsg((String)"Call ObjectMessage.isBodyAssignableTo(Boolean.class) (expect false)");
                boolean b = actObjectMessage.isBodyAssignableTo(Boolean.class);
                if (b) {
                    TestUtil.logErr((String)"Expected false got true");
                    pass = false;
                }
                TestUtil.logMsg((String)"Call ObjectMessage.isBodyAssignableTo(StringBuffer.class) (expect true)");
                b = actObjectMessage.isBodyAssignableTo(StringBuffer.class);
                if (!b) {
                    TestUtil.logErr((String)"Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive BytesMessage");
            BytesMessage actBytesMessage = (BytesMessage)this.consumer.receive(this.timeout);
            if (actBytesMessage == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                TestUtil.logMsg((String)"Call BytesMessage.isBodyAssignableTo(String.class) (expect false)");
                boolean b = actBytesMessage.isBodyAssignableTo(String.class);
                if (b) {
                    TestUtil.logErr((String)"Expected false got true");
                    pass = false;
                }
                TestUtil.logMsg((String)"Call BytesMessage.isBodyAssignableTo(byte[].class) (expect true)");
                b = actBytesMessage.isBodyAssignableTo(byte[].class);
                if (!b) {
                    TestUtil.logErr((String)"Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long) to receive MapMessage");
            MapMessage actMapMessage = (MapMessage)this.consumer.receive(this.timeout);
            if (actMapMessage == null) {
                throw new Exception("Did not receive MapMessage");
            }
            try {
                TestUtil.logMsg((String)"Call MapMessage.isBodyAssignableTo(String.class) (expect false)");
                boolean b = actMapMessage.isBodyAssignableTo(String.class);
                if (b) {
                    TestUtil.logErr((String)"Expected false got true");
                    pass = false;
                }
                TestUtil.logMsg((String)"Call MapMessage.isBodyAssignableTo(Map.class) (expect true)");
                b = actMapMessage.isBodyAssignableTo(Map.class);
                if (!b) {
                    TestUtil.logErr((String)"Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("isBodyAssignableToTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("isBodyAssignableToTest failed");
        }
    }
}

