/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.tests.signaturetest.ApiCheckRecorder;
import com.sun.ts.tests.signaturetest.Recorder;
import com.sun.ts.tests.signaturetest.SigTestRecorder;

public class RecorderFactory {
    public static final String API_CHECK_RECORDER = "apicheck";
    public static final String SIG_TEST_RECORDER = "sigtest";

    public static Recorder getRecorder(String type, String[] args) {
        if (type == null) {
            throw new IllegalArgumentException("'type' cannot be null");
        }
        if (type.equals(API_CHECK_RECORDER)) {
            return new ApiCheckRecorder(args);
        }
        if (type.equals(SIG_TEST_RECORDER)) {
            return new SigTestRecorder(args);
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static void main(String[] args) {
        String type = System.getProperty("recorder.type", SIG_TEST_RECORDER);
        Recorder recorder = RecorderFactory.getRecorder(type, args);
        recorder.batchRecord();
    }
}

