/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Beer;
import ee.jakarta.tck.nosql.entities.Coffee;
import ee.jakarta.tck.nosql.entities.Drink;
import ee.jakarta.tck.nosql.factories.DrinkListSupplier;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The query execution exploring the inheritance annotation")
public class SelectTemplateInheritanceTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with less-than condition on alcoholPercentage")
    void shouldInsertIterableAndSelectWithLessThanCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Drink.class).where("alcoholPercentage").lt((Object)(entities.get(0).getAlcoholPercentage() + 1.0)).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(drink -> drink.getAlcoholPercentage() <= ((Drink)entities.get(0)).getAlcoholPercentage());
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with less-than-or-equal condition on alcoholPercentage")
    void shouldInsertIterableAndSelectWithLessThanOrEqualCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Drink.class).where("alcoholPercentage").lte((Object)entities.get(0).getAlcoholPercentage()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(drink -> drink.getAlcoholPercentage() <= ((Drink)entities.get(0)).getAlcoholPercentage());
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with greater-than condition on alcoholPercentage")
    void shouldInsertIterableAndSelectWithGreaterThanCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Drink secondDrink = entities.stream().sorted(Comparator.comparingDouble(Drink::getAlcoholPercentage)).skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Drink.class).where("alcoholPercentage").gt((Object)secondDrink.getAlcoholPercentage()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(drink -> drink.getAlcoholPercentage() > secondDrink.getAlcoholPercentage());
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with greater-than-or-equal condition on alcoholPercentage")
    void shouldInsertIterableAndSelectWithGreaterThanOrEqualCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Drink.class).where("alcoholPercentage").gte((Object)entities.get(0).getAlcoholPercentage()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(drink -> drink.getAlcoholPercentage() >= ((Drink)entities.get(0)).getAlcoholPercentage());
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'between' condition on alcoholPercentage")
    void shouldInsertIterableAndSelectWithBetweenCondition(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Drink secondDrink = entities.stream().sorted(Comparator.comparingDouble(Drink::getAlcoholPercentage)).skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Drink.class).where("alcoholPercentage").between((Object)secondDrink.getAlcoholPercentage(), (Object)(secondDrink.getAlcoholPercentage() + 5.0)).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(drink -> drink.getAlcoholPercentage() >= secondDrink.getAlcoholPercentage() && drink.getAlcoholPercentage() <= secondDrink.getAlcoholPercentage() + 5.0);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="should select by type, where the type is a drink")
    void shouldSelectByType(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List coffees = this.template.select(Coffee.class).result();
            List beers = this.template.select(Beer.class).result();
            ((ListAssert)Assertions.assertThat((List)coffees).isNotEmpty()).allMatch(Coffee.class::isInstance);
            ((ListAssert)Assertions.assertThat((List)beers).isNotEmpty()).allMatch(Beer.class::isInstance);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should select query using subtype")
    void shouldDoQueryBySubType(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Coffee coffee = entities.stream().filter(Coffee.class::isInstance).map(Coffee.class::cast).findFirst().orElseThrow();
            List coffees = this.template.select(Coffee.class).where("country").eq((Object)coffee.getCountry()).result();
            ((ListAssert)Assertions.assertThat((List)coffees).isNotEmpty()).allMatch(c -> c.getCountry().equals(coffee.getCountry()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkListSupplier.class)
    @DisplayName(value="Should select query using subtype")
    void shouldDoQueryBySubType2(List<Drink> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Beer beer = entities.stream().filter(Beer.class::isInstance).map(Beer.class::cast).findFirst().orElseThrow();
            List beers = this.template.select(Beer.class).where("style").eq((Object)beer.getStyle()).result();
            ((ListAssert)Assertions.assertThat((List)beers).isNotEmpty()).allMatch(c -> c.getStyle().equals(beer.getStyle()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

