/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.entities;

import jakarta.nosql.Column;
import jakarta.nosql.Entity;
import jakarta.nosql.Id;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.datafaker.Faker;

@Entity
public class Person {
    @Id
    private String id;
    @Column
    private String name;
    @Column(value="native_age")
    private Integer age;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return Objects.equals(this.id, person.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Person{id=" + this.id + ", name='" + this.name + "', age=" + this.age + "}";
    }

    public static Person of(Faker faker) {
        Person person = new Person();
        long id = ThreadLocalRandom.current().nextLong(1L, 1000000L);
        int age = ThreadLocalRandom.current().nextInt(1, 100);
        person.setId(String.valueOf(id));
        person.setName(faker.name().fullName());
        person.setAge(age);
        return person;
    }
}

