/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Person;
import ee.jakarta.tck.nosql.factories.PersonSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The basic template operations using a POJO entity")
class BasicTemplateTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicTemplateTest.class.getName());

    BasicTemplateTest() {
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonSupplier.class)
    @DisplayName(value="Should insert the person: {0}")
    void shouldInsert(Person entity) {
        Person person = (Person)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)person).isNotNull();
            soft.assertThat(person.getId()).isNotNull();
            soft.assertThat(person.getName()).isEqualTo(entity.getName());
            soft.assertThat(person.getAge()).isEqualTo((Object)entity.getAge());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonSupplier.class)
    @DisplayName(value="Should update the person: {0}")
    void shouldUpdate(Person entity) {
        Person insertedPerson = (Person)this.template.insert((Object)entity);
        insertedPerson.setAge(insertedPerson.getAge() + 1);
        Person updatedPerson = (Person)this.template.update((Object)insertedPerson);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedPerson).isNotNull();
            soft.assertThat(updatedPerson.getId()).isEqualTo(insertedPerson.getId());
            soft.assertThat(updatedPerson.getAge()).isEqualTo((Object)insertedPerson.getAge());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonSupplier.class)
    @DisplayName(value="Should delete the person: {0}")
    void shouldDelete(Person entity) {
        Person insertedPerson = (Person)this.template.insert((Object)entity);
        this.template.delete(Person.class, (Object)insertedPerson.getId());
        Optional deletedPerson = this.template.find(Person.class, (Object)insertedPerson.getId());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedPerson).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonSupplier.class)
    @DisplayName(value="Should find the person: {0}")
    void shouldFind(Person entity) {
        Person insertedPerson = (Person)this.template.insert((Object)entity);
        Optional foundPerson = this.template.find(Person.class, (Object)insertedPerson.getId());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundPerson).isPresent();
            soft.assertThat(((Person)foundPerson.orElseThrow()).getId()).isEqualTo(insertedPerson.getId());
            soft.assertThat(((Person)foundPerson.orElseThrow()).getName()).isEqualTo(insertedPerson.getName());
            soft.assertThat(((Person)foundPerson.orElseThrow()).getAge()).isEqualTo((Object)insertedPerson.getAge());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonSupplier.class)
    @DisplayName(value="Should insert vehicle with TTL")
    void shouldInsertWithTTL(Person person) {
        try {
            Person insertedPerson = (Person)this.template.insert((Object)person, Duration.ofMinutes(10L));
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat((Object)insertedPerson).isNotNull();
                soft.assertThat(insertedPerson.getId()).isNotNull();
                soft.assertThat(insertedPerson.getName()).isEqualTo(person.getName());
            });
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("TTL operation not supported by this database: " + e.getMessage());
        }
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is inserted")
    void shouldThrowExceptionWhenNullEntityInserted() {
        Assertions.assertThatThrownBy(() -> this.template.insert(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is updated")
    void shouldThrowExceptionWhenNullEntityUpdated() {
        Assertions.assertThatThrownBy(() -> this.template.update(null)).isInstanceOf(NullPointerException.class);
    }
}

