/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Drink;
import ee.jakarta.tck.nosql.factories.DrinkSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="Basic operations exploring Inheritance with Inheritance annotations")
public class BasicTemplateInheritanceTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicTemplateInheritanceTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=DrinkSupplier.class)
    @DisplayName(value="Should insert the drink: {0}")
    void shouldInsert(Drink entity) {
        Drink drink = (Drink)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)drink).isNotNull();
            soft.assertThat(drink.getId()).isNotNull();
            soft.assertThat(drink.getName()).isEqualTo(entity.getName());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkSupplier.class)
    @DisplayName(value="Should update the drink: {0}")
    void shouldUpdate(Drink entity) {
        Drink insertedDrink = (Drink)this.template.insert((Object)entity);
        insertedDrink.setName(insertedDrink.getName() + " Updated");
        Drink updatedDrink = (Drink)this.template.update((Object)insertedDrink);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedDrink).isNotNull();
            soft.assertThat(updatedDrink.getId()).isEqualTo(insertedDrink.getId());
            soft.assertThat(updatedDrink.getName()).isEqualTo(insertedDrink.getName());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkSupplier.class)
    @DisplayName(value="Should delete the drink: {0}")
    void shouldDelete(Drink entity) {
        Drink insertedDrink = (Drink)this.template.insert((Object)entity);
        this.template.delete(insertedDrink.getClass(), (Object)insertedDrink.getId());
        Optional deletedDrink = this.template.find(insertedDrink.getClass(), (Object)insertedDrink.getId());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedDrink).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkSupplier.class)
    @DisplayName(value="Should find the drink: {0}")
    void shouldFind(Drink entity) {
        Drink insertedDrink = (Drink)this.template.insert((Object)entity);
        Optional foundDrink = this.template.find(insertedDrink.getClass(), (Object)insertedDrink.getId());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundDrink).isPresent();
            soft.assertThat(((Drink)foundDrink.orElseThrow()).getId()).isEqualTo(insertedDrink.getId());
            soft.assertThat(((Drink)foundDrink.orElseThrow()).getName()).isEqualTo(insertedDrink.getName());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=DrinkSupplier.class)
    @DisplayName(value="Should insert drink with TTL")
    void shouldInsertWithTTL(Drink drink) {
        try {
            Drink insertedDrink = (Drink)this.template.insert((Object)drink, Duration.ofMinutes(10L));
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat((Object)insertedDrink).isNotNull();
                soft.assertThat(insertedDrink.getId()).isNotNull();
                soft.assertThat(insertedDrink.getName()).isEqualTo(drink.getName());
            });
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("TTL operation not supported by this database: " + e.getMessage());
        }
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is inserted")
    void shouldThrowExceptionWhenNullEntityInserted() {
        Assertions.assertThatThrownBy(() -> this.template.insert(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is updated")
    void shouldThrowExceptionWhenNullEntityUpdated() {
        Assertions.assertThatThrownBy(() -> this.template.update(null)).isInstanceOf(NullPointerException.class);
    }
}

