/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Person;
import ee.jakarta.tck.nosql.entities.Vehicle;
import ee.jakarta.tck.nosql.factories.PersonListSupplier;
import ee.jakarta.tck.nosql.factories.VehicleListSupplier;
import java.util.List;
import java.util.stream.StreamSupport;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The iterable template operations")
public class BasicIterableEntityTemplateTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert a list of persons")
    void shouldInsertIterablePerson(List<Person> entities) {
        Iterable result = this.template.insert(entities);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(result).hasSize(entities.size());
            result.forEach(person -> {
                soft.assertThat(person).isNotNull();
                soft.assertThat(person.getId()).isNotNull();
                soft.assertThat(person.getName()).isNotNull();
                soft.assertThat(person.getAge()).isNotNull();
            });
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleListSupplier.class)
    @DisplayName(value="Should insert a list of vehicles")
    void shouldInsertIterableVehicle(List<Vehicle> entities) {
        Iterable result = this.template.insert(entities);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(result).hasSize(entities.size());
            result.forEach(vehicle -> {
                soft.assertThat(vehicle).isNotNull();
                soft.assertThat(vehicle.getId()).isNotNull();
                soft.assertThat(vehicle.getModel()).isNotNull();
                soft.assertThat(vehicle.getMake()).isNotNull();
            });
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should update a list of persons")
    void shouldUpdateIterablePerson(List<Person> entities) {
        Iterable people = this.template.insert(entities);
        List<Person> updatedEntities = StreamSupport.stream(people.spliterator(), false).peek(p -> p.setName(p.getName() + "updated")).toList();
        Iterable result = this.template.update(updatedEntities);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(result).hasSize(entities.size());
            result.forEach(person -> {
                soft.assertThat(person).isNotNull();
                soft.assertThat(person.getId()).isNotNull();
                soft.assertThat(person.getName()).isNotNull();
                soft.assertThat(person.getAge()).isNotNull();
                soft.assertThat(person.getName()).contains(new CharSequence[]{"updated"});
            });
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleListSupplier.class)
    @DisplayName(value="Should update a list of vehicles")
    void shouldUpdateIterableVehicle(List<Vehicle> entities) {
        Iterable vehicles = this.template.insert(entities);
        List<Vehicle> updatedEntities = StreamSupport.stream(vehicles.spliterator(), false).peek(v -> v.setModel(v.getModel() + "updated")).toList();
        Iterable result = this.template.update(updatedEntities);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(result).hasSize(entities.size());
            result.forEach(vehicle -> {
                soft.assertThat(vehicle).isNotNull();
                soft.assertThat(vehicle.getId()).isNotNull();
                soft.assertThat(vehicle.getModel()).isNotNull();
                soft.assertThat(vehicle.getMake()).isNotNull();
                soft.assertThat(vehicle.getModel()).contains(new CharSequence[]{"updated"});
            });
        });
    }
}

