/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Fruit;
import ee.jakarta.tck.nosql.entities.Money;
import ee.jakarta.tck.nosql.factories.FruitSupplier;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The basic template operations with entity that contains a converter field")
public class BasicConverterFieldTemplateTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicConverterFieldTemplateTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=FruitSupplier.class)
    @DisplayName(value="Should insert fruit with converted field: {0}")
    void shouldInsert(Fruit entity) {
        Fruit fruit = (Fruit)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)fruit).isNotNull();
            soft.assertThat(fruit.getId()).isNotNull();
            soft.assertThat(fruit.getName()).isEqualTo(entity.getName());
            soft.assertThat((Object)fruit.getPrice()).isEqualTo((Object)entity.getPrice());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitSupplier.class)
    @DisplayName(value="Should update fruit with converted field: {0}")
    void shouldUpdate(Fruit entity) {
        Fruit insertedFruit = (Fruit)this.template.insert((Object)entity);
        insertedFruit.setPrice(new Money(insertedFruit.getPrice().currency(), insertedFruit.getPrice().value().add(BigDecimal.TEN)));
        Fruit updatedFruit = (Fruit)this.template.update((Object)insertedFruit);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedFruit).isNotNull();
            soft.assertThat(updatedFruit.getPrice().value()).isEqualTo((Object)insertedFruit.getPrice().value());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitSupplier.class)
    @DisplayName(value="Should delete fruit with converted field: {0}")
    void shouldDelete(Fruit entity) {
        Fruit insertedFruit = (Fruit)this.template.insert((Object)entity);
        this.template.delete(Fruit.class, (Object)insertedFruit.getId());
        Optional deletedFruit = this.template.find(Fruit.class, (Object)insertedFruit.getId());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedFruit).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitSupplier.class)
    @DisplayName(value="Should find fruit with converted field: {0}")
    void shouldFind(Fruit entity) {
        Fruit insertedFruit = (Fruit)this.template.insert((Object)entity);
        Optional foundFruit = this.template.find(Fruit.class, (Object)insertedFruit.getId());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundFruit).isPresent();
            soft.assertThat((Object)((Fruit)foundFruit.orElseThrow()).getPrice()).isEqualTo((Object)insertedFruit.getPrice());
        });
    }
}

