/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.linkresolver.resolver;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;

public class LinkResolver {
    private RepositoryAdapter repositoryAdapter;
    private IntentDocumentQuery documentQuery;

    public LinkResolver(RepositoryAdapter repositoryAdapter) {
        this.repositoryAdapter = repositoryAdapter;
        this.documentQuery = new IntentDocumentQuery(repositoryAdapter);
    }

    public void resolve(IProgressMonitor monitor) {
        Collection allIntentReferenceInstructions = new IntentDocumentQuery(this.repositoryAdapter).getAllIntentReferenceInstructions();
        for (IntentReferenceInstruction referenceInstruction : allIntentReferenceInstructions) {
            this.resolveReference(referenceInstruction);
        }
    }

    private void resolveReference(IntentReferenceInstruction referenceInstruction) {
        String href = referenceInstruction.getIntentHref();
        if (href != null && href.length() > 0) {
            IntentStructuredElement element = (IntentStructuredElement)this.documentQuery.getAllIdentifiedElements().get(href);
            if (element != null) {
                referenceInstruction.setReferencedElement((EObject)element);
            } else {
                IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "Unresolved " + href);
            }
        }
    }
}

