/**
 * Copyright (c) 2010, 2012 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 */
package org.eclipse.mylyn.docs.intent.core.document;

import org.eclipse.mylyn.docs.intent.markup.markup.Section;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Intent Structured Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement#getCompleteLevel <em>Complete Level</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage#getIntentStructuredElement()
 * @model abstract="true"
 * @generated
 */
public interface IntentStructuredElement extends Section, IntentGenericElement {
	/**
	 * Returns the value of the '<em><b>Complete Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Complete Level</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Complete Level</em>' attribute.
	 * @see #setCompleteLevel(String)
	 * @see org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage#getIntentStructuredElement_CompleteLevel()
	 * @model
	 * @generated
	 */
	String getCompleteLevel();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement#getCompleteLevel <em>Complete Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Complete Level</em>' attribute.
	 * @see #getCompleteLevel()
	 * @generated
	 */
	void setCompleteLevel(String value);

} // IntentStructuredElement
