/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInputFactory;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.query.DescriptionUnitHelper;
import org.eclipse.mylyn.docs.intent.core.query.StructuredElementHelper;
import org.eclipse.ui.IMemento;
import org.osgi.framework.Bundle;

public class IntentEditorInput
extends URIEditorInput {
    private static final int MAX_TITLE_SIZE = 25;
    private static final String URI_FRAGMENT_TAG = "uri_fragment";
    private EObject element;
    private String elementTitle;
    private RepositoryAdapter repositoryAdapter;

    public IntentEditorInput(EObject elementToOpen, RepositoryAdapter repositoryAdapter) {
        super(EcoreUtil.getURI((EObject)elementToOpen));
        this.element = elementToOpen;
        this.elementTitle = this.getTitleFromElement(repositoryAdapter, elementToOpen);
        this.repositoryAdapter = repositoryAdapter;
    }

    public IntentEditorInput(IMemento memento) {
        super(memento);
    }

    public EObject getIntentElement() {
        return this.element;
    }

    public String getTitleFromElement(RepositoryAdapter adapter, EObject newElement) {
        String newTitle = "";
        if (newElement instanceof ModelingUnit && ((newTitle = ((ModelingUnit)newElement).getName()) == null || newTitle.length() < 1)) {
            newTitle = "ModelingUnit";
        }
        if (newElement instanceof DescriptionUnit) {
            newTitle = DescriptionUnitHelper.getDescriptionUnitTitle((DescriptionUnit)((DescriptionUnit)newElement), (int)25);
        }
        if (newElement instanceof IntentDocument) {
            newTitle = adapter.getRepository().getIdentifier().replace(".idoc", "");
        } else if (newElement instanceof IntentStructuredElement && ((newTitle = StructuredElementHelper.getTitle((IntentStructuredElement)((IntentStructuredElement)newElement))) == null || newTitle.length() < 1)) {
            newTitle = newElement.eClass().getName();
        }
        if (newTitle.length() > 25) {
            newTitle = newTitle.substring(0, 25);
        }
        return newTitle;
    }

    public String getName() {
        return this.elementTitle;
    }

    public String getToolTipText() {
        return this.elementTitle;
    }

    public void setName(String newName) {
        this.elementTitle = newName;
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        Resource resource = this.getResource();
        if (resource != null) {
            String uriFragment = memento.getString(URI_FRAGMENT_TAG);
            this.element = uriFragment != null ? resource.getEObject(uriFragment) : (EObject)resource.getContents().iterator().next();
            this.elementTitle = this.getTitleFromElement(this.repositoryAdapter, this.element);
        }
    }

    private Resource getResource() {
        if (this.repositoryAdapter == null && this.getRepository() != null) {
            this.repositoryAdapter = this.getRepository().createRepositoryAdapter();
            try {
                this.repositoryAdapter.openSaveContext();
            }
            catch (ReadOnlyException readOnlyException) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "The Intent Editor has insufficient rights (read-only) to save modifications on the repository. A read-only context will be used instead.");
            }
        }
        if (this.repositoryAdapter != null) {
            return this.repositoryAdapter.getResource(this.repositoryAdapter.getResourcePath(this.getURI().trimFragment()));
        }
        return null;
    }

    public Repository getRepository() {
        try {
            return IntentRepositoryManager.INSTANCE.getRepository(this.getURI().toString());
        }
        catch (RepositoryConnectionException e) {
            IntentUiLogger.logError(e);
        }
        catch (CoreException e) {
            IntentUiLogger.logError(e);
        }
        return null;
    }

    public RepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.element != null && this.element.eResource() != null) {
            memento.putString(URI_FRAGMENT_TAG, this.element.eResource().getURIFragment(this.element));
            memento.putString("class", ((Object)((Object)this)).getClass().getName());
        } else {
            IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "Could not save Intent Editor state");
        }
    }

    protected String getBundleSymbolicName() {
        return IntentEditorActivator.getDefault().getBundle().getSymbolicName();
    }

    public String getFactoryId() {
        return IntentEditorInputFactory.ID;
    }

    static IntentEditorInput create(IMemento memento) {
        String bundleSymbolicName = memento.getString("bundle");
        String className = memento.getString("class");
        try {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            Class theClass = bundle.loadClass(className);
            Constructor constructor = theClass.getConstructor(IMemento.class);
            return (IntentEditorInput)((Object)constructor.newInstance(memento));
        }
        catch (Exception exception) {
            CommonUIPlugin.INSTANCE.log((Object)exception);
            return new IntentEditorInput(memento);
        }
    }
}

