/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.HasAttributeCopyAttributes;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SBlock;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SList;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SSection;
import org.eclipse.mylyn.docs.intent.markup.builder.state.STable;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.List;
import org.eclipse.mylyn.docs.intent.markup.markup.ListType;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.Table;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public abstract class AbstractSContainer
extends BuilderState {
    private Container root;

    public AbstractSContainer(BuilderState previous, Container doc) {
        super(previous);
        this.root = doc;
    }

    public BuilderState endDocument() {
        this.removeUselessBlocks();
        return this.previousState();
    }

    public BuilderState beginHeading(int level, Attributes attributes) {
        Section newSec = MarkupFactory.eINSTANCE.createSection();
        new HasAttributeCopyAttributes(newSec).setValues(attributes);
        newSec.setLevel(level);
        this.root.getContent().add((Object)newSec);
        return new SSection((BuilderState)this, newSec);
    }

    public BuilderState beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        SBlock resultState = null;
        this.removeUselessBlocks();
        Block created = MarkupFactory.eINSTANCE.createBlock();
        switch (type) {
            case PARAGRAPH: {
                created = MarkupFactory.eINSTANCE.createParagraph();
                new HasAttributeCopyAttributes(created).setValues(attributes);
                break;
            }
            case QUOTE: {
                created = MarkupFactory.eINSTANCE.createQuote();
                new HasAttributeCopyAttributes(created).setValues(attributes);
                break;
            }
            case CODE: {
                created = MarkupFactory.eINSTANCE.createCode();
                new HasAttributeCopyAttributes(created).setValues(attributes);
                break;
            }
            case PREFORMATTED: {
                created = MarkupFactory.eINSTANCE.createPreformatted();
                new HasAttributeCopyAttributes(created).setValues(attributes);
                break;
            }
            case NUMERIC_LIST: 
            case BULLETED_LIST: {
                List newList = MarkupFactory.eINSTANCE.createList();
                new HasAttributeCopyAttributes(newList).setValues(attributes);
                if (type.equals((Object)DocumentBuilder.BlockType.BULLETED_LIST)) {
                    newList.setListType(ListType.BULLETED);
                } else {
                    newList.setListType(ListType.NUMERIC);
                }
                new HasAttributeCopyAttributes(newList).setValues(attributes);
                this.root.getContent().add((Object)newList);
                resultState = new SList((BuilderState)this, newList);
                break;
            }
            case TABLE: {
                Table newTable = MarkupFactory.eINSTANCE.createTable();
                new HasAttributeCopyAttributes(newTable).setValues(attributes);
                this.root.getContent().add((Object)newTable);
                resultState = new STable((BuilderState)this, newTable);
                break;
            }
        }
        this.root.getContent().add((Object)created);
        if (resultState == null) {
            resultState = new SBlock(this, created);
        }
        return resultState;
    }

    protected void removeUselessBlocks() {
        Block block;
        EObject lastElement;
        if (this.root.getContent().size() >= 1 && (lastElement = (EObject)this.root.getContent().get(this.root.getContent().size() - 1)) instanceof Block && this.isUselessBlock(block = (Block)lastElement)) {
            this.root.getContent().remove((Object)block);
        }
    }

    private boolean isUselessBlock(Block block) {
        if (block instanceof List) {
            return ((List)block).getItems().isEmpty();
        }
        return block.getContent().isEmpty();
    }
}

