/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.AbstractIntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.IntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.external.parser.IntentExternalParserContributionRegistry;
import org.eclipse.mylyn.docs.intent.external.parser.contribution.ExternalParserCompletionProposal;
import org.eclipse.mylyn.docs.intent.external.parser.contribution.IExternalParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionUnitCompletionProcessor
extends AbstractIntentCompletionProcessor {
    public DescriptionUnitCompletionProcessor(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals() {
        ArrayList proposals = Lists.newArrayList();
        proposals.addAll(this.getExtendedParsersCompletionProposals(this.getCurrentSentences()));
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private Collection<? extends ICompletionProposal> getExtendedParsersCompletionProposals(Iterable<String> currentSentences) {
        ArrayList proposals = Lists.newArrayList();
        for (IExternalParser externalParserContribution : IntentExternalParserContributionRegistry.getExternalParserContributions()) {
            for (ExternalParserCompletionProposal proposal : externalParserContribution.getCompletionVariablesProposals(currentSentences)) {
                proposals.add(this.createVariableProposal(proposal));
            }
            for (ExternalParserCompletionProposal proposal : externalParserContribution.getCompletionTemplatesProposals(currentSentences)) {
                proposals.add(this.createTemplateProposalWithExternalImage(proposal.getName(), proposal.getDescription(), proposal.getPattern(), proposal.getImage()));
            }
        }
        return proposals;
    }

    private Iterable<String> getCurrentSentences() {
        try {
            String text = this.document.get(0, this.offset);
            int paragraphStartOffset = -1;
            Pattern[] patternArray = IntentCompletionProcessor.PATTERNS_BY_CONTEXT;
            int n = IntentCompletionProcessor.PATTERNS_BY_CONTEXT.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern startPargraphPattern = patternArray[n2];
                paragraphStartOffset = Math.max(paragraphStartOffset, this.getLastIndexOf(text, startPargraphPattern));
                ++n2;
            }
            if (paragraphStartOffset > -1) {
                text = text.substring(paragraphStartOffset);
            }
            return Splitter.on((String)"\n").split((CharSequence)text);
        }
        catch (BadLocationException badLocationException) {
            return Sets.newLinkedHashSet();
        }
    }

    @Override
    public String getContextType() {
        return "__dftl_partition_content_type";
    }
}

