/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.scanner;

import org.eclipse.jface.text.rules.IWordDetector;

public class IntentWordDetector
implements IWordDetector {
    private static char[] standardCharacters = new char[]{'@', ';', '.'};
    private static char[] modelingUnitCharacters = new char[]{';', '+', '='};
    private static char[] descriptionUnitCharacters = new char[]{'(', ')', ',', ':', '?', '!', '-'};
    private boolean isModelingUnit;

    public IntentWordDetector() {
        this.isModelingUnit = false;
    }

    public IntentWordDetector(boolean isModelingUnit) {
        this.isModelingUnit = true;
    }

    public final boolean isWordStart(char c) {
        return Character.isLetter(c) || this.isStandardCharacter(c) || this.isStyleCharacter(c) || this.isModelingUnitCharacter(c);
    }

    public final boolean isWordPart(char c) {
        return Character.isLetterOrDigit(c) || this.isStandardCharacter(c) || this.isStyleCharacter(c) || this.isModelingUnitCharacter(c);
    }

    private boolean isModelingUnitCharacter(char c) {
        boolean isModelingUnitCharater = false;
        if (this.isModelingUnit) {
            int count = 0;
            while (!isModelingUnitCharater && count < modelingUnitCharacters.length) {
                isModelingUnitCharater = c == modelingUnitCharacters[count];
                ++count;
            }
        }
        return isModelingUnitCharater;
    }

    private boolean isStandardCharacter(char c) {
        boolean isStandardCharacter = false;
        int count = 0;
        while (!isStandardCharacter && count < standardCharacters.length) {
            isStandardCharacter = c == standardCharacters[count];
            ++count;
        }
        return isStandardCharacter;
    }

    private boolean isStyleCharacter(char c) {
        boolean isStyleCharacter = false;
        int count = 0;
        while (!isStyleCharacter && count < descriptionUnitCharacters.length) {
            isStyleCharacter = c == descriptionUnitCharacters[count];
            ++count;
        }
        return isStyleCharacter;
    }
}

