/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorImpl;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPairMatcher;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentQuickOutlineControl;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentMultiPageEditor
extends MultiPageEditorPart
implements IntentEditor {
    private IntentEditorImpl intentEditor;
    private Browser browser;
    private IntentSerializer intentSerializer = new IntentSerializer();

    public IntentMultiPageEditor() {
        this.intentEditor = new IntentEditorImpl();
    }

    protected void createPages() {
        try {
            this.addPage((IEditorPart)this.intentEditor, this.getEditorInput());
            this.setPageText(0, "Intent editor ");
            this.setPageImage(0, IntentEditorActivator.getDefault().getImage("icon/outline/document.gif"));
            if (this.shouldDisplayPreviewPage()) {
                try {
                    this.browser = new Browser(this.getContainer(), 0);
                    this.addPage(1, (Control)this.browser);
                    this.setPageText(1, "Preview ");
                    this.browser.setUrl(this.getHTMLPreviewURL());
                    this.setPageImage(1, IntentEditorActivator.getDefault().getImage("icon/outline/html.png"));
                }
                catch (SWTError e) {
                    IntentUiLogger.logError("Could not initialize browser for Intent real-time preview, preference is deactivated.", e);
                    InstanceScope.INSTANCE.getNode("org.eclipse.mylyn.docs.intent.client.ui").putBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.show_preview_page", false);
                }
            }
        }
        catch (PartInitException e) {
            IntentUiLogger.logError(e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setPartName(input.getName());
        super.init(site, input);
    }

    private boolean shouldDisplayPreviewPage() {
        return IntentPreferenceService.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.show_preview_page");
    }

    /*
     * Unable to fully structure code
     */
    private String getHTMLPreviewURL() {
        block2: {
            htmlPreviewLocation = "file:///" + ((IntentEditorInput)this.getEditorInput()).getRepository().getRepositoryLocation() + "generated/html/";
            container = ((IntentEditorInput)this.getEditorInput()).getIntentElement();
            if (!(container instanceof IntentDocument)) ** GOTO lbl7
            htmlPreviewLocation = String.valueOf(htmlPreviewLocation) + "IntentDocumentation.html";
            break block2;
lbl-1000:
            // 1 sources

            {
                container = container.eContainer();
lbl7:
                // 2 sources

                ** while (container != null && (!(container instanceof IntentStructuredElement) || ((IntentStructuredElement)container).getTitle() == null))
            }
lbl8:
            // 1 sources

            if (container instanceof IntentStructuredElement) {
                htmlPreviewLocation = String.valueOf(htmlPreviewLocation) + ((IntentStructuredElement)container).getCompleteLevel() + "_" + this.intentSerializer.serialize((EObject)((IntentStructuredElement)container).getTitle()).replace(" ", "") + ".html";
            }
        }
        return htmlPreviewLocation;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (this.browser != null && newPageIndex == 1) {
            this.browser.setUrl(this.getHTMLPreviewURL());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.intentEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.intentEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.intentEditor.isSaveAsAllowed();
    }

    public IDocumentProvider getDocumentProvider() {
        return this.intentEditor.getDocumentProvider();
    }

    public void close(boolean save) {
        this.intentEditor.close(save);
    }

    public boolean isEditable() {
        return this.intentEditor.isEditable();
    }

    public void doRevertToSaved() {
        this.intentEditor.doRevertToSaved();
    }

    public void setAction(String actionID, IAction action) {
        this.intentEditor.setAction(actionID, action);
    }

    public IAction getAction(String actionId) {
        return this.intentEditor.getAction(actionId);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this.intentEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void removeActionActivationCode(String actionId) {
        this.intentEditor.removeActionActivationCode(actionId);
    }

    public boolean showsHighlightRangeOnly() {
        return this.intentEditor.showsHighlightRangeOnly();
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.intentEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this.intentEditor.setHighlightRange(offset, length, moveCursor);
    }

    public IRegion getHighlightRange() {
        return this.intentEditor.getHighlightRange();
    }

    public void resetHighlightRange() {
        this.intentEditor.resetHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.intentEditor.getSelectionProvider();
    }

    public void selectAndReveal(int offset, int length) {
        this.intentEditor.selectAndReveal(offset, length);
    }

    @Override
    public EObject getIntentContent() {
        return this.intentEditor.getIntentContent();
    }

    @Override
    public boolean containsElement(IntentGenericElement elementToOpen) {
        return this.intentEditor.containsElement(elementToOpen);
    }

    @Override
    public boolean selectRange(IntentGenericElement elementToSelectRangeWithLoadedFromAdapter) {
        this.setActivePage(0);
        return this.intentEditor.selectRange(elementToSelectRangeWithLoadedFromAdapter);
    }

    @Override
    public IntentPairMatcher getBlockMatcher() {
        return this.intentEditor.getBlockMatcher();
    }

    @Override
    public ColorManager getColorManager() {
        return this.intentEditor.getColorManager();
    }

    @Override
    public IntentQuickOutlineControl getCurrentQuickOutline() {
        return this.intentEditor.getCurrentQuickOutline();
    }

    @Override
    public void refreshOutlineView(EObject newAST) {
        this.intentEditor.refreshOutlineView(newAST);
    }

    @Override
    public void refreshTitle(EObject newAST) {
        this.intentEditor.refreshTitle(newAST);
    }

    @Override
    public boolean isInitialFoldingStructureComplete() {
        return this.intentEditor.isInitialFoldingStructureComplete();
    }

    @Override
    public void updateFoldingStructure(Map<Annotation, Position> addedAnnotations, List<Annotation> deletedAnnotations, Map<Annotation, Position> modifiedAnnotations) {
        this.intentEditor.updateFoldingStructure(addedAnnotations, deletedAnnotations, modifiedAnnotations);
    }

    @Override
    public ProjectionViewer getProjectionViewer() {
        return this.intentEditor.getProjectionViewer();
    }

    @Override
    public SourceViewerConfiguration getViewerConfiguration() {
        return this.intentEditor.getViewerConfiguration();
    }

    @Override
    public IInformationPresenter createQuickOutlinePresenter() {
        return this.intentEditor.createQuickOutlinePresenter();
    }
}

