/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.query;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.docs.intent.markup.serializer.TextSerializer;

public final class DescriptionUnitHelper {
    private static final int MARKUP_ELEMENT_MAXLENGTH = 50;

    private DescriptionUnitHelper() {
    }

    public static String getDescriptionUnitTitle(DescriptionUnit descriptionUnit, int maxSize) {
        String title = "";
        Iterator iterator = descriptionUnit.getInstructions().iterator();
        while ("".equals(title) && iterator.hasNext()) {
            UnitInstruction nextInstruction = (UnitInstruction)iterator.next();
            if (!(nextInstruction instanceof DescriptionBloc)) continue;
            title = DescriptionUnitHelper.getDescriptionBlocTitle((DescriptionBloc)nextInstruction, maxSize);
        }
        return title;
    }

    public static String getDescriptionBlocTitle(DescriptionBloc descriptionBlock, int maxSize) {
        String title = "";
        Iterator iterator = descriptionBlock.getDescriptionBloc().getContent().iterator();
        while ("".equals(title) && iterator.hasNext()) {
            title = DescriptionUnitHelper.getLabelForMarkupElement((StructureElement)iterator.next(), maxSize);
        }
        return title;
    }

    public static String getLabelForMarkupElement(StructureElement element, int maxSize) {
        String label = "";
        int actualMaxSize = maxSize;
        if (actualMaxSize == -1) {
            actualMaxSize = 50;
        }
        if (element instanceof Section) {
            label = DescriptionUnitHelper.getLabelForSection((Section)element, actualMaxSize);
        }
        if (element instanceof Block) {
            label = DescriptionUnitHelper.getLabelForBlock((Block)element, actualMaxSize);
        }
        return label;
    }

    private static String getLabelForSection(Section section, int maxSize) {
        return DescriptionUnitHelper.getLabelForBlock(section.getTitle(), maxSize);
    }

    private static String getLabelForBlock(Block block, int maxSize) {
        String title = "";
        for (EObject obj : block.eContents()) {
            String newTitleElement = "";
            if (obj instanceof Text) {
                newTitleElement = TextSerializer.render((Text)((Text)obj)).replace("\t", "");
            } else if (obj instanceof Block) {
                if (title.length() > 0) {
                    newTitleElement = String.valueOf(newTitleElement) + " , ";
                }
                newTitleElement = String.valueOf(newTitleElement) + DescriptionUnitHelper.getLabelForBlock((Block)obj, maxSize);
            }
            title = newTitleElement.length() + title.length() > maxSize ? String.valueOf(title) + newTitleElement.substring(0, maxSize - title.length()) : String.valueOf(title) + newTitleElement;
            if (title.length() > maxSize) break;
        }
        return title;
    }
}

