/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.query.AbstractIntentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.InstructionTraceabilityEntry;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceabilityInformationsQuery
extends AbstractIntentQuery {
    private TraceabilityIndex traceabilityIndex;

    public TraceabilityInformationsQuery(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    public TraceabilityIndex getOrCreateTraceabilityIndex() {
        if (this.traceabilityIndex == null) {
            try {
                final Resource traceabilityResource = this.repositoryAdapter.getOrCreateResource("/COMPILATION/TRACES/TraceabilityIndex");
                if (traceabilityResource.getContents().isEmpty()) {
                    this.repositoryAdapter.execute(new IntentCommand(){

                        public void execute() {
                            traceabilityResource.getContents().add((Object)CompilerFactory.eINSTANCE.createTraceabilityIndex());
                        }
                    });
                }
                this.traceabilityIndex = (TraceabilityIndex)traceabilityResource.getContents().get(0);
            }
            catch (ReadOnlyException e) {
                throw new RuntimeException(e);
            }
        }
        return this.traceabilityIndex;
    }

    public Collection<ContributionInstruction> getAllRelatedContributions(UnitInstruction instruction) {
        return Sets.newLinkedHashSet((Iterable)Iterables.filter(this.getAllRelatedInstructions(instruction), ContributionInstruction.class));
    }

    public InstanciationInstruction getInstanciation(EObject instance) {
        for (TraceabilityIndexEntry entry : this.getOrCreateTraceabilityIndex().getEntries()) {
            EList instructions = (EList)entry.getContainedElementToInstructions().get((Object)instance);
            if (instructions == null) continue;
            for (InstructionTraceabilityEntry instructionTraceabilityEntry : instructions) {
                if (!(instructionTraceabilityEntry.getInstruction() instanceof InstanciationInstruction)) continue;
                return (InstanciationInstruction)instructionTraceabilityEntry.getInstruction();
            }
        }
        return null;
    }

    public List<InstanciationInstruction> getInstanciations() {
        ArrayList<InstanciationInstruction> instanciations = new ArrayList<InstanciationInstruction>();
        for (TraceabilityIndexEntry entry : this.getOrCreateTraceabilityIndex().getEntries()) {
            Collection mapValues = entry.getContainedElementToInstructions().values();
            if (mapValues == null) continue;
            for (EList instructions : mapValues) {
                for (InstructionTraceabilityEntry instructionTraceabilityEntry : instructions) {
                    if (!(instructionTraceabilityEntry.getInstruction() instanceof InstanciationInstruction)) continue;
                    instanciations.add((InstanciationInstruction)instructionTraceabilityEntry.getInstruction());
                }
            }
        }
        return instanciations;
    }

    public EObject getInstance(InstanciationInstruction instanciation) {
        for (TraceabilityIndexEntry entry : this.getOrCreateTraceabilityIndex().getEntries()) {
            for (Map.Entry instructionsEntry : entry.getContainedElementToInstructions()) {
                for (InstructionTraceabilityEntry instructionTraceabilityEntry : (EList)instructionsEntry.getValue()) {
                    if (!instructionTraceabilityEntry.getInstruction().equals(instanciation)) continue;
                    return (EObject)instructionsEntry.getKey();
                }
            }
        }
        return null;
    }

    public ModelingUnitInstructionReference getModelingUnitInstructionReference(InstanciationInstruction instanciation) {
        for (TraceabilityIndexEntry entry : this.getOrCreateTraceabilityIndex().getEntries()) {
            for (ModelingUnitInstructionReference reference : entry.getResourceDeclaration().getContent()) {
                if (!instanciation.equals(reference.getReferencedInstruction())) continue;
                return reference;
            }
        }
        return null;
    }

    private Collection<ModelingUnitInstruction> getAllRelatedInstructions(UnitInstruction instruction) {
        LinkedHashSet relatedInstructions = Sets.newLinkedHashSet();
        boolean foundContributions = false;
        Iterator traceabilityIterator = this.getOrCreateTraceabilityIndex().getEntries().iterator();
        while (traceabilityIterator.hasNext() && !foundContributions) {
            TraceabilityIndexEntry entry = (TraceabilityIndexEntry)traceabilityIterator.next();
            Iterator iterator = entry.getContainedElementToInstructions().iterator();
            while (iterator.hasNext() && !foundContributions) {
                Map.Entry element = (Map.Entry)iterator.next();
                HashSet<IntentGenericElement> instructions = new HashSet<IntentGenericElement>(((EList)element.getValue()).size());
                for (InstructionTraceabilityEntry instructionEntry : (EList)element.getValue()) {
                    instructions.add(instructionEntry.getInstruction());
                }
                if (!instructions.contains(instruction)) continue;
                relatedInstructions.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter(instructions, ContributionInstruction.class)));
                foundContributions = true;
            }
        }
        return relatedInstructions;
    }

    public InstanciationInstruction getInstanciationInstruction(ModelingUnitInstruction instruction) {
        InstanciationInstruction instancationInstruction = null;
        ModelingUnitInstruction mostSpecificInstruction = instruction;
        if (mostSpecificInstruction instanceof InstanciationInstruction) {
            instancationInstruction = (InstanciationInstruction)mostSpecificInstruction;
        } else if (mostSpecificInstruction instanceof ContributionInstruction) {
            if (((ContributionInstruction)mostSpecificInstruction).getContributionReference() != null && ((ContributionInstruction)mostSpecificInstruction).getContributionReference().getReferencedInstruction() instanceof InstanciationInstruction) {
                instancationInstruction = (InstanciationInstruction)((ContributionInstruction)mostSpecificInstruction).getContributionReference().getReferencedInstruction();
            }
        } else if (mostSpecificInstruction instanceof StructuralFeatureAffectation && ((StructuralFeatureAffectation)mostSpecificInstruction).getValues().size() > 0 && ((StructuralFeatureAffectation)mostSpecificInstruction).getValues().iterator().next() instanceof ReferenceValueForStructuralFeature) {
            mostSpecificInstruction = (ReferenceValueForStructuralFeature)((StructuralFeatureAffectation)instruction).getValues().iterator().next();
        }
        if (mostSpecificInstruction instanceof ReferenceValueForStructuralFeature && ((ReferenceValueForStructuralFeature)mostSpecificInstruction).getInstanciationReference() instanceof InstanciationInstructionReference) {
            instancationInstruction = ((ReferenceValueForStructuralFeature)mostSpecificInstruction).getInstanciationReference().getInstanciation();
        }
        return instancationInstruction;
    }

    public URI getWorkingCopyResourceURI(ModelingUnitInstruction instruction, boolean ifNoneFoundReturnCompiledResource) {
        URI workingCopyResourceURI = null;
        InstanciationInstruction instanciationInstruction = this.getInstanciationInstruction(instruction);
        if (instanciationInstruction != null) {
            TraceabilityIndexEntry matchingTraceabilityEntry = null;
            for (TraceabilityIndexEntry entry : this.getOrCreateTraceabilityIndex().getEntries()) {
                block1: for (Map.Entry instructionsEntry : entry.getContainedElementToInstructions()) {
                    for (InstructionTraceabilityEntry instructionTraceabilityEntry : (EList)instructionsEntry.getValue()) {
                        if (!instructionTraceabilityEntry.getInstruction().equals(instanciationInstruction)) continue;
                        matchingTraceabilityEntry = entry;
                        continue block1;
                    }
                }
            }
            if (matchingTraceabilityEntry != null) {
                if (matchingTraceabilityEntry.getResourceDeclaration().getUri() != null) {
                    workingCopyResourceURI = URI.createURI((String)matchingTraceabilityEntry.getResourceDeclaration().getUri().toString().replace("\"", ""));
                } else if (ifNoneFoundReturnCompiledResource) {
                    workingCopyResourceURI = this.repositoryAdapter.getResource(matchingTraceabilityEntry.getGeneratedResourcePath().replace("\"", "")).getURI();
                }
            }
        }
        return workingCopyResourceURI;
    }
}

