/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.resource;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.mylyn.docs.intent.markup.builder.ModelDocumentBuilder;
import org.eclipse.mylyn.docs.intent.markup.markup.Document;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;
import org.eclipse.mylyn.docs.intent.markup.markup.Link;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.resource.ImageFetchingContentHandler;
import org.eclipse.mylyn.docs.intent.markup.resource.WikimediaURI;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.IgnoreDtdEntityResolver;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikimediaResource
extends ResourceImpl {
    private static final int BUFFER_SIZE = 65536;

    public WikimediaResource(URI eUri) {
        super(eUri);
    }

    public void load(Map<?, ?> options) throws IOException {
        URI uri = this.getURI();
        WikimediaURI wURI = new WikimediaURI(uri);
        String pageName = wURI.pageName();
        String apiURI = String.valueOf(wURI.baseServer()) + "/api.php?format=xml&action=query&prop=revisions&titles=" + pageName + "&rvprop=content";
        URI eApiURI = URI.createURI((String)apiURI);
        HashMap response = null;
        if (options != null) {
            response = (HashMap)options.get("RESPONSE");
        }
        if (response == null) {
            response = new HashMap();
        }
        InputStream inputStream = this.getInputStream(eApiURI);
        URI eImgURI = URI.createURI((String)(String.valueOf(wURI.baseServer()) + "/api.php?action=query&titles=" + pageName + "&generator=images&prop=imageinfo&iiprop=url&format=xml"));
        InputStream inputImage = this.getInputStream(eImgURI);
        try {
            try {
                this.wikimediaLoad(inputStream, options);
                this.handleImagesData(eImgURI, wURI.baseServer(), inputImage);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            inputStream.close();
            inputImage.close();
            Long timeStamp = (Long)response.get("TIME_STAMP");
            if (timeStamp != null) {
                this.setTimeStamp(timeStamp);
            }
        }
        this.prepareProxyFromLinks();
    }

    private void handleImagesData(URI eImgURI, String baseServer, InputStream input) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        SAXParser saxParser = parserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver((EntityResolver)IgnoreDtdEntityResolver.getInstance());
        ImageFetchingContentHandler contentHandler = new ImageFetchingContentHandler();
        xmlReader.setContentHandler(contentHandler);
        try {
            xmlReader.parse(new InputSource(input));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unexpected exception retrieving data from %s", eImgURI), e);
        }
        if (contentHandler.imageTitleToUrl.size() > 0) {
            UnmodifiableIterator it = Iterators.filter((Iterator)this.getAllContents(), Image.class);
            while (it.hasNext()) {
                Image cur = (Image)it.next();
                String completeURL = contentHandler.imageTitleToUrl.get("Image:" + cur.getUrl());
                if (completeURL == null) continue;
                cur.setUrl(String.valueOf(baseServer) + "/" + completeURL);
            }
        }
    }

    private InputStream getInputStream(URI eApiURI) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getURIConverter().createInputStream(eApiURI);
        }
        catch (IOException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw exception;
        }
        return inputStream;
    }

    private void prepareProxyFromLinks() {
        UnmodifiableIterator it = Iterators.filter((Iterator)this.getAllContents(), Link.class);
        while (it.hasNext()) {
            Link lnk = (Link)it.next();
            String href = lnk.getHrefOrHashName();
            if (lnk.getTarget() != null || !href.startsWith("/wiki/")) continue;
            String targetPageName = href.substring(href.indexOf("/wiki/") + 6);
            URI uri = this.getURI();
            URI targetUri = uri.trimSegments(uri.segmentCount());
            targetUri = URI.createURI((String)(String.valueOf(targetUri.toString()) + targetPageName + "#/0"));
            Document proxifiedDoc = MarkupFactory.eINSTANCE.createDocument();
            ((InternalEObject)proxifiedDoc).eSetProxyURI(targetUri);
            lnk.setTarget(proxifiedDoc);
        }
    }

    private void wikimediaLoad(InputStream is, Map<?, ?> options) throws SAXException, IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        String outString = out.toString();
        int begin = outString.indexOf("<rev>") + 4;
        int end = outString.indexOf("</rev>");
        String revisionContent = outString.substring(begin + 1, end - begin);
        MarkupParser parser = new MarkupParser((MarkupLanguage)new MediaWikiLanguage());
        ModelDocumentBuilder builder = new ModelDocumentBuilder();
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(revisionContent, true);
        Collection<EObject> roots = builder.getRoots();
        this.getContents().addAll(roots);
    }
}

