/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.SimpleContainer;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;
import org.eclipse.mylyn.docs.intent.markup.serializer.AttributeStyleSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.BlockSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextElementDispatcher;

public final class SectionSerializer {
    private SectionSerializer() {
    }

    public static String render(Section section, WikiTextElementDispatcher dispatcher) {
        String breakLine = "";
        if (!SectionSerializer.isContainedinSimpleContainer(section)) {
            breakLine = SectionSerializer.isFirstSection(section) ? "\n" : "\n\n";
        }
        if (BlockSerializer.usePrefix().booleanValue()) {
            breakLine = "";
            BlockSerializer.breakPreformatted();
        }
        String style = AttributeStyleSerializer.renderAttributeForBloc(section.getAttributes());
        String renderedForm = "h" + section.getLevel() + style + ". ";
        if (section.getTitle() != null) {
            for (BlockContent titleElement : section.getTitle().getContent()) {
                renderedForm = String.valueOf(renderedForm) + (String)dispatcher.doSwitch((EObject)titleElement);
            }
            renderedForm = String.valueOf(breakLine) + renderedForm + "\n" + "\n";
        }
        for (StructureElement blockContent : section.getContent()) {
            renderedForm = String.valueOf(renderedForm) + (String)dispatcher.doSwitch((EObject)blockContent);
        }
        return renderedForm;
    }

    private static boolean isContainedinSimpleContainer(Section section) {
        return section.eContainer() instanceof SimpleContainer;
    }

    private static boolean isFirstSection(Section section) {
        return section.eContainer().eContents().get(0) == section;
    }

    static boolean isFirstElementOfSection(StructureElement element) {
        return element.eContainer().eContents().get(0) == element;
    }

    static boolean isLastElementOfSection(StructureElement element) {
        EObject container = element.eContainer();
        EList<StructureElement> listOfContents = null;
        if (container instanceof Container) {
            listOfContents = ((Container)container).getContent();
            return listOfContents.lastIndexOf((Object)element) == listOfContents.size() - 1;
        }
        return false;
    }
}

