/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;

public class MergeEmptyResourceFix
extends AbstractIntentFix {
    public MergeEmptyResourceFix(Annotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        SynchronizerCompilationStatus status = (SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus();
        String workingCopyResourceURI = status.getWorkingCopyResourceURI().replace("\"", "");
        String generatedResourceURI = status.getCompiledResourceURI().replace("\"", "");
        Resource generatedResource = repositoryAdapter.getResource(generatedResourceURI);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource workingCopyResource = rs.getResource(URI.createURI((String)workingCopyResourceURI), true);
        workingCopyResource.getContents().addAll(EcoreUtil.copyAll((Collection)generatedResource.getContents()));
        try {
            workingCopyResource.save(null);
        }
        catch (IOException e) {
            IntentUiLogger.logError(e);
        }
    }

    public String getDisplayString() {
        return "Fill the working copy with the document content";
    }
}

