/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state;

import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.HasAttributeCopyAttributes;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.ListTableOfContentsResolver;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SBlock;
import org.eclipse.mylyn.docs.intent.markup.markup.List;
import org.eclipse.mylyn.docs.intent.markup.markup.ListItem;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class SList
extends SBlock {
    private List list;

    public SList(BuilderState previous, List block) {
        super(previous, block);
        this.list = block;
    }

    public BuilderState beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        if (this.list instanceof ListItem) {
            ((ListItem)this.list).setIsList(true);
        }
        if (type == DocumentBuilder.BlockType.BULLETED_LIST || type == DocumentBuilder.BlockType.NUMERIC_LIST) {
            ListItem newItem = MarkupFactory.eINSTANCE.createListItem();
            newItem.setListType(this.list.getListType());
            new HasAttributeCopyAttributes(newItem).setValues(attributes);
            newItem.setImbricationLevel(this.list.getImbricationLevel() + 1);
            this.list.getItems().add((Object)newItem);
            return new SList((BuilderState)this, this.list);
        }
        if (type == DocumentBuilder.BlockType.LIST_ITEM) {
            ListItem newItem = MarkupFactory.eINSTANCE.createListItem();
            newItem.setListType(this.list.getListType());
            newItem.setImbricationLevel(this.list.getImbricationLevel());
            new HasAttributeCopyAttributes(newItem).setValues(attributes);
            this.list.getItems().add((Object)newItem);
            return new SBlock(this, newItem);
        }
        throw new RuntimeException();
    }

    public BuilderState endBlock() {
        ListTableOfContentsResolver tocResolver = new ListTableOfContentsResolver(this.list);
        tocResolver.resolveTableOfContents();
        return this.previousState();
    }
}

