/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.repository;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mylyn.docs.intent.collab.common.location.IntentLocations;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotificationFactory;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotificationFactoryHolder;
import org.eclipse.mylyn.docs.intent.collab.ide.notification.WorkspaceRepositoryChangeNotificationFactory;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceConfig;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerPackage;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnitPackage;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.genericunit.GenericUnitPackage;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerPackage;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitPackage;

public class IntentWorkspaceRepositoryCreator
implements RepositoryCreator {
    public Repository createRepository(Object artifact, RepositoryStructurer structurer) throws RepositoryConnectionException {
        if (artifact instanceof IProject) {
            WorkspaceConfig configurationInformations = new WorkspaceConfig((IProject)artifact, IntentLocations.INDEXES_LIST);
            WorkspaceRepository repository = new WorkspaceRepository(configurationInformations, new EClass[]{IntentIndexerPackage.eINSTANCE.getIntentIndex()});
            if (RepositoryChangeNotificationFactoryHolder.getChangeNotificationFactory() == null) {
                RepositoryChangeNotificationFactoryHolder.setChangeNotificationFactory((RepositoryChangeNotificationFactory)new WorkspaceRepositoryChangeNotificationFactory());
            }
            this.initializePackageRegistry((Repository)repository);
            repository.setRepositoryStructurer(structurer);
            return repository;
        }
        throw new RepositoryConnectionException("The given configuration artifact are invalid.");
    }

    protected void initializePackageRegistry(Repository repository) throws RepositoryConnectionException {
        for (String epackageURI : EPackage.Registry.INSTANCE.keySet()) {
            repository.getPackageRegistry().put((Object)epackageURI, EPackage.Registry.INSTANCE.get((Object)epackageURI));
        }
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/indexer/0.7", (Object)IntentIndexerPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/compilerinfos/0.7", (Object)CompilerPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/intentdocument/0.7", (Object)IntentDocumentPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/modelingunit/0.7", (Object)ModelingUnitPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/descriptionunit/0.7", (Object)DescriptionUnitPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/intent/genericunit/0.7", (Object)GenericUnitPackage.eINSTANCE);
        repository.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/CDO/Eresource/4.0.0", (Object)EresourcePackage.eINSTANCE);
    }
}

