/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.match;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.compare.match.AbstractGenericMatchEngineToCheckerBridge;
import org.eclipse.mylyn.docs.intent.compare.match.StatisticBasedSimilarityChecker;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

public class IntentSimilarityChecker
extends StatisticBasedSimilarityChecker {
    private static final double MAX_SIMILARITY = 0.9999;
    private EObject localRoot;
    private EObject repositoryRoot;

    public IntentSimilarityChecker(MetamodelFilter metamodelFilter, AbstractGenericMatchEngineToCheckerBridge bridge, EObject localRoot, EObject repositoryRoot) {
        super(metamodelFilter, bridge);
        this.localRoot = localRoot;
        this.repositoryRoot = repositoryRoot;
    }

    public boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        boolean isSimilar = this.isSimilar(obj1, obj2, false);
        return isSimilar;
    }

    public boolean isSimilar(EObject obj1, EObject obj2, boolean useGenericMatcher) throws FactoryException {
        boolean isSimilar = false;
        boolean haveSpecificMatcher = false;
        if (useGenericMatcher) {
            return super.isSimilar(obj1, obj2);
        }
        if (this.areRoots(obj1, obj2)) {
            isSimilar = true;
            haveSpecificMatcher = true;
        } else if (obj1 instanceof DescriptionBloc && obj2 instanceof DescriptionBloc) {
            isSimilar = this.areSimilarDescriptionBlocs((DescriptionBloc)obj1, (DescriptionBloc)obj2);
            haveSpecificMatcher = true;
        } else if (obj1 instanceof IntentStructuredElement && obj2 instanceof IntentStructuredElement) {
            isSimilar = this.areSimilarStructuredElements((IntentStructuredElement)obj1, (IntentStructuredElement)obj2);
            haveSpecificMatcher = true;
        } else if (obj1 instanceof Paragraph && obj2 instanceof Paragraph) {
            isSimilar = this.areSimilarParagraphs((Paragraph)obj1, (Paragraph)obj2);
            haveSpecificMatcher = true;
        }
        if (!haveSpecificMatcher) {
            isSimilar = super.isSimilar(obj1, obj2);
        }
        return isSimilar;
    }

    public EObject fastLookup(EObject obj1) {
        if (obj1 == this.localRoot) {
            return this.repositoryRoot;
        }
        return super.fastLookup(obj1);
    }

    public double absoluteMetric(EObject obj1, EObject obj2) throws FactoryException {
        if (this.areRoots(obj1, obj2)) {
            return 0.9999;
        }
        if (obj1 instanceof IntentStructuredElement && obj2 instanceof IntentStructuredElement) {
            if (this.areSimilarStructuredElements((IntentStructuredElement)obj1, (IntentStructuredElement)obj2)) {
                return 1.0;
            }
            return 0.0;
        }
        return super.absoluteMetric(obj1, obj2);
    }

    private boolean areRoots(EObject obj1, EObject obj2) {
        return obj1 == this.localRoot && obj2 == this.repositoryRoot;
    }

    protected boolean areSimilarStructuredElements(IntentStructuredElement element1, IntentStructuredElement element2) throws FactoryException {
        boolean areSimilarStructuredElements = false;
        Block title1 = element1.getTitle();
        Block title2 = element2.getTitle();
        if (title1 != null && title2 != null) {
            return this.isSimilar((EObject)title1, (EObject)title2);
        }
        if (title1 == null && title2 == null) {
            areSimilarStructuredElements = this.isSimilar((EObject)element1, (EObject)element2, true);
        }
        return areSimilarStructuredElements;
    }

    protected double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        if (obj1 instanceof IntentSubSectionContainer && obj2 instanceof IntentSubSectionContainer) {
            return 0.97;
        }
        return super.contentSimilarity(obj1, obj2);
    }

    protected double relationsSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        if (obj1 instanceof IntentSubSectionContainer && obj2 instanceof IntentSubSectionContainer) {
            Double value = this.getSimilarityFromCache(obj1, obj2, 'r');
            double similarity = 0.0;
            if (value != null) {
                similarity = value;
            } else {
                similarity = this.getIntentStructuredElementsSimilarity((IntentSubSectionContainer)obj1, (IntentSubSectionContainer)obj2);
                this.setSimilarityInCache(obj1, obj2, 'r', similarity);
            }
            return similarity;
        }
        return super.relationsSimilarity(obj1, obj2);
    }

    private double getIntentStructuredElementsSimilarity(IntentSubSectionContainer obj1, IntentSubSectionContainer obj2) throws FactoryException {
        double numberOfTotalElements = obj1.getIntentContent().size();
        double numberOfCommonElements = 0.0;
        ArrayList obj1Elements = Lists.newArrayList((Iterable)obj1.getIntentContent());
        ArrayList obj2Elements = Lists.newArrayList((Iterable)obj2.getIntentContent());
        block0: for (EObject obj2Element : obj2Elements) {
            Iterator obj1ElementsIterator = obj1Elements.iterator();
            while (obj1ElementsIterator.hasNext()) {
                EObject obj1Element = (EObject)obj1ElementsIterator.next();
                if (!this.isSimilar(obj1Element, obj2Element)) continue;
                numberOfCommonElements += 1.0;
                obj1ElementsIterator.remove();
                continue block0;
            }
        }
        if (obj2.getIntentContent().size() > obj1.getIntentContent().size()) {
            numberOfTotalElements += (double)(obj2.getIntentContent().size() - obj1.getIntentContent().size());
        }
        if (numberOfTotalElements > 0.0) {
            double similarity = numberOfCommonElements / numberOfTotalElements;
            if (similarity >= 0.5 && numberOfTotalElements <= 4.0) {
                similarity = Math.max(similarity, 0.99);
            } else if (similarity >= 0.5) {
                similarity = 0.5 + numberOfCommonElements / (numberOfTotalElements * 2.0);
            }
            return similarity;
        }
        return 1.0;
    }

    private boolean areSimilarDescriptionBlocs(DescriptionBloc obj1, DescriptionBloc obj2) {
        int positionInContainer2;
        int positionInContainer1 = obj1.eContainer().eContents().indexOf((Object)obj1);
        boolean haveSamePositionInContainer = positionInContainer1 == (positionInContainer2 = obj2.eContainer().eContents().indexOf((Object)obj2));
        return haveSamePositionInContainer;
    }

    private boolean areSimilarParagraphs(Paragraph obj1, Paragraph obj2) {
        LinkedHashSet obj1Texts = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)obj1.getContent(), Text.class));
        LinkedHashSet obj2Texts = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)obj2.getContent(), Text.class));
        String obj1AsString = "";
        for (Text t : obj1Texts) {
            obj1AsString = String.valueOf(obj1AsString) + t.getData();
        }
        String obj2AsString = "";
        for (Text t : obj2Texts) {
            obj2AsString = String.valueOf(obj2AsString) + t.getData();
        }
        return obj1AsString.equals(obj2AsString);
    }
}

