/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.handly.util.LruCache;

public class LruCacheTest
extends TestCase {
    private LruCache<String, Integer> cache;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new LruCache();
    }

    public void test1() {
        LruCacheTest.assertEquals((int)0, (int)this.cache.size());
        LruCacheTest.assertTrue((boolean)this.cache.isEmpty());
        LruCacheTest.assertNull((Object)this.cache.get((Object)"a"));
        LruCacheTest.assertNull((Object)this.cache.peek((Object)"b"));
        LruCacheTest.assertNull((Object)this.cache.remove((Object)"c"));
        LruCacheTest.assertTrue((boolean)this.cache.snapshot().isEmpty());
        this.cache.clear();
    }

    public void test2() {
        LruCacheTest.assertNull((Object)this.cache.put((Object)"a", (Object)1));
        LruCacheTest.assertEquals((int)1, (int)this.cache.size());
        LruCacheTest.assertFalse((boolean)this.cache.isEmpty());
        LruCacheTest.assertEquals((int)1, (int)((Integer)this.cache.get((Object)"a")));
        LruCacheTest.assertNull((Object)this.cache.put((Object)"b", (Object)2));
        LruCacheTest.assertEquals((int)2, (int)this.cache.size());
        LruCacheTest.assertFalse((boolean)this.cache.isEmpty());
        LruCacheTest.assertEquals(Arrays.asList("b", "a"), new ArrayList(this.cache.snapshot().keySet()));
        LruCacheTest.assertEquals((int)1, (int)((Integer)this.cache.put((Object)"a", (Object)3)));
        LruCacheTest.assertEquals(Arrays.asList("a", "b"), new ArrayList(this.cache.snapshot().keySet()));
        LruCacheTest.assertEquals((int)2, (int)((Integer)this.cache.get((Object)"b")));
        LruCacheTest.assertEquals(Arrays.asList("b", "a"), new ArrayList(this.cache.snapshot().keySet()));
        LruCacheTest.assertEquals((int)3, (int)((Integer)this.cache.peek((Object)"a")));
        LruCacheTest.assertEquals(Arrays.asList("b", "a"), new ArrayList(this.cache.snapshot().keySet()));
        LruCacheTest.assertNull((Object)this.cache.put((Object)"c", (Object)1));
        LruCacheTest.assertEquals((int)3, (int)this.cache.size());
        LruCacheTest.assertFalse((boolean)this.cache.isEmpty());
        LruCacheTest.assertEquals(Arrays.asList("c", "b", "a"), new ArrayList(this.cache.snapshot().keySet()));
        LruCacheTest.assertEquals((int)2, (int)((Integer)this.cache.remove((Object)"b")));
        LruCacheTest.assertEquals((int)2, (int)this.cache.size());
        LruCacheTest.assertFalse((boolean)this.cache.isEmpty());
        LruCacheTest.assertEquals(Arrays.asList("c", "a"), new ArrayList(this.cache.snapshot().keySet()));
        this.cache.clear();
        LruCacheTest.assertEquals((int)0, (int)this.cache.size());
        LruCacheTest.assertTrue((boolean)this.cache.isEmpty());
    }

    public void test3() {
        try {
            this.cache.put(null, (Object)1);
            LruCacheTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.cache.put((Object)"a", null);
            LruCacheTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

