/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.operations.CutOperation;
import org.eclipse.glsp.server.operations.DeleteOperation;
import org.eclipse.glsp.server.operations.GModelOperationHandler;

public class GModelCutOperationHandler
extends GModelOperationHandler<CutOperation> {
    @Inject
    protected ActionDispatcher actionDispatcher;

    protected List<String> getElementsToCut(CutOperation cutAction) {
        return cutAction.getEditorContext().getSelectedElementIds();
    }

    @Override
    public Optional<Command> createCommand(CutOperation operation) {
        List<String> elementsToCut = this.getElementsToCut(operation);
        return elementsToCut.isEmpty() ? GModelCutOperationHandler.doNothing() : this.commandOf(() -> {
            CompletableFuture<Void> completableFuture = this.actionDispatcher.dispatch(new DeleteOperation(elementsToCut));
        });
    }
}

