/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocRunner;
import org.eclipse.gendoc.wizard.ISelectionConverter;

public class PreferenceGendocSelectionConverter
implements ISelectionConverter {
    private PreferenceGendocRunner preferenceGenDocRunner;

    public PreferenceGendocSelectionConverter(PreferenceGendocRunner preferenceGenDocRunner) {
        this.preferenceGenDocRunner = preferenceGenDocRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(Object selectedObject) {
        if (this.preferenceGenDocRunner.getProject() == null) {
            return true;
        }
        IFile file = this.getFile(selectedObject);
        if (file == null) {
            return false;
        }
        if (file.getProject() == this.preferenceGenDocRunner.getProject()) {
            return true;
        }
        try {
            IProject[] refProjects;
            IProject[] iProjectArray = refProjects = file.getProject().getReferencedProjects();
            int n = refProjects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IProject p = iProjectArray[n2];
                if (p == file.getProject()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IFile getFile(Object selectedObject) {
        IFile file;
        EObject eobj = this.getEObject(selectedObject);
        if (eobj instanceof EObject) {
            Resource eresource = eobj.eResource();
            if (eresource == null) {
                return null;
            }
            URI eUri = eresource.getURI();
            if (eUri.isPlatformResource()) {
                String platformString = eUri.toPlatformString(true);
                selectedObject = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            }
        }
        if ((file = (IFile)Platform.getAdapterManager().getAdapter(selectedObject, IFile.class)) == null && selectedObject instanceof IAdaptable) {
            file = (IFile)((IAdaptable)selectedObject).getAdapter(IFile.class);
        }
        if (file != null && file.getFileExtension() != null && file.getFileExtension().endsWith("di")) {
            String name = file.getName();
            IResource r = file.getParent().findMember(String.valueOf(name.substring(0, name.length() - 2)) + "uml");
            if (r instanceof IFile) {
                file = (IFile)r;
            }
        }
        return file;
    }

    private EObject getEObject(Object obj) {
        EObject eobj = (EObject)Platform.getAdapterManager().getAdapter(obj, EObject.class);
        if (eobj == null && obj instanceof IAdaptable) {
            eobj = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
        }
        return eobj;
    }
}

