/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.impl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gendoc.bundle.acceleo.gmf.service.GMFDiagramRenderer;
import org.eclipse.gendoc.bundle.acceleo.gmf.service.IDiagramRenderer;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IImageManipulationService;
import org.eclipse.gendoc.documents.IImageManipulationServiceFactory;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;

public class GMFDiagramRunnable
implements FileRunnable {
    private Diagram diagram;
    private IDiagramRenderer.FileFormat extension;
    private final List<EObject> visibleElements;

    public GMFDiagramRunnable(Diagram diagram, String extension) {
        this(diagram, extension, null);
    }

    public GMFDiagramRunnable(Diagram diagram, String extension, List<EObject> visibleElements) {
        this.diagram = diagram;
        this.extension = IDiagramRenderer.FileFormat.transformToFormat(extension);
        this.visibleElements = visibleElements != null ? visibleElements : Collections.emptyList();
    }

    public void run(final String resourceId, final String outputResourceFolder) {
        if (Realm.getDefault() == null) {
            Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)Display.getDefault()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    GMFDiagramRunnable.this.doRun(resourceId, outputResourceFolder);
                }
            });
        } else {
            this.doRun(resourceId, outputResourceFolder);
        }
    }

    protected void doRun(String resourceId, String outputResourceFolder) {
        if (this.extension != null) {
            IDiagramRenderer diagramRenderer = (IDiagramRenderer)GendocServices.getDefault().getService(IDiagramRenderer.class);
            if (diagramRenderer == null) {
                diagramRenderer = new GMFDiagramRenderer();
            }
            new File(outputResourceFolder).mkdirs();
            Path path = new Path(String.valueOf(outputResourceFolder) + "/" + resourceId + this.extension.getFullExtension());
            try {
                ResourceSet resourceSet;
                Resource eResource = this.diagram.eResource();
                if (eResource != null && TransactionUtil.getEditingDomain((ResourceSet)(resourceSet = eResource.getResourceSet())) == null) {
                    TransactionalEditingDomain.Factory factory = TransactionalEditingDomain.Factory.INSTANCE;
                    factory.createEditingDomain(resourceSet);
                }
                diagramRenderer.renderDiagram(this.diagram, this.visibleElements, (IPath)path, this.extension, new NullProgressMonitor());
                IImageManipulationServiceFactory imageManipulationServiceFactory = (IImageManipulationServiceFactory)GendocServices.getDefault().getService(IImageManipulationServiceFactory.class);
                IImageManipulationService imageManipulationService = imageManipulationServiceFactory.getService(this.extension.name().toLowerCase());
                imageManipulationService.transform((IPath)path);
            }
            catch (CoreException e) {
                IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                if (diag != null) {
                    diag.addDiagnostic(2, "no image can be generated for Diagram : " + this.diagram.toString(), (Object)new Object[]{this.diagram});
                }
                e.printStackTrace();
            }
            catch (Exception ex) {
                IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                if (diag != null) {
                    diag.addDiagnostic(2, "no image can be generated for Diagram : " + this.diagram.toString(), (Object)new Object[]{this.diagram});
                }
                ex.printStackTrace();
            }
        }
    }

    public String getFileExtension() {
        return this.extension.toString().toLowerCase();
    }
}

