/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.catalina.util.RequestUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class FileDirContext
extends BaseDirContext {
    private static Log log = LogFactory.getLog(FileDirContext.class);
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable env) {
        super(env);
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.base = new File(docBase);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", docBase));
        }
        this.absoluteBase = this.base.getAbsolutePath();
        super.setDocBase(docBase);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void release() {
        super.release();
    }

    protected String doGetRealPath(String path) {
        File file = new File(this.getDocBase(), path);
        return file.getAbsolutePath();
    }

    protected Object doLookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        if (file.isDirectory()) {
            FileDirContext tempContext = new FileDirContext(this.env);
            tempContext.setDocBase(file.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        if (!file.delete()) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", name));
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", oldName));
        }
        File newFile = new File(this.base, newName);
        file.renameTo(newFile);
    }

    public NamingEnumeration list(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextEnumeration(this.list(file).iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextBindingsEnumeration(this.list(file).iterator(), this);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new FileResourceAttributes(file);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        this.rebind(name, obj, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        InputStream is = null;
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException e) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
            if (!file.mkdir()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
        }
        if (is == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        try {
            block16: {
                FileOutputStream os = null;
                byte[] buffer = new byte[2048];
                int len = -1;
                try {
                    os = new FileOutputStream(file);
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    Object var10_12 = null;
                    if (os == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (os != null) {
                        os.close();
                    }
                    is.close();
                    throw throwable;
                }
                os.close();
            }
            is.close();
            {
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException(this.sm.getString("resources.bindFailed", e));
            ne.initCause(e);
            throw ne;
        }
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        if (!file.mkdir()) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        return (DirContext)this.lookup(name);
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    protected String normalize(String path) {
        return RequestUtil.normalize(path, File.separatorChar == '\\');
    }

    protected File file(String name) {
        File file = new File(this.base, name);
        if (file.exists() && file.canRead()) {
            if (this.allowLinking) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!canPath.startsWith(this.absoluteBase)) {
                return null;
            }
            if (this.caseSensitive) {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = fileAbsPath + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                if (canPath != null) {
                    canPath = this.normalize(canPath);
                }
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    absPath = absPath.substring(this.absoluteBase.length() + 1);
                    if (canPath == null || absPath == null) {
                        return null;
                    }
                    if (absPath.equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        canPath = "/";
                    }
                    if (!canPath.equals(absPath)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        return file;
    }

    protected ArrayList list(File file) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        if (names == null) {
            log.warn((Object)this.sm.getString("fileResources.listingNull", file.getAbsolutePath()));
            return entries;
        }
        Arrays.sort(names);
        if (names == null) {
            return entries;
        }
        NamingEntry entry = null;
        for (int i = 0; i < names.length; ++i) {
            File currentFile = new File(file, (String)names[i]);
            Object object = null;
            if (currentFile.isDirectory()) {
                FileDirContext tempContext = new FileDirContext(this.env);
                tempContext.setDocBase(file.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new NamingEntry((String)names[i], object, 0);
            entries.add(entry);
        }
        return entries;
    }

    protected class FileResourceAttributes
    extends ResourceAttributes {
        protected File file;
        protected boolean accessed = false;
        protected String canonicalPath = null;

        public FileResourceAttributes(File file) {
            this.file = file;
            this.getCreation();
            this.getLastModified();
        }

        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.getLastModified();
            return this.creation;
        }

        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.getCreation();
            }
            return super.getCreationDate();
        }

        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.getLastModified();
            }
            return super.getLastModifiedDate();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        public String getCanonicalPath() {
            if (this.canonicalPath == null) {
                try {
                    this.canonicalPath = this.file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.canonicalPath;
        }
    }

    protected class FileResource
    extends Resource {
        protected File file;
        protected long length = -1L;

        public FileResource(File file) {
            this.file = file;
        }

        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                FileInputStream fis = new FileInputStream(this.file);
                this.inputStream = fis;
                return fis;
            }
            return super.streamContent();
        }
    }
}

