/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class PartialSpecAnnotationProvider
extends AnnotationProvider {
    private final String annotationName;

    public PartialSpecAnnotationProvider(String annotationName) {
        this.annotationName = annotationName;
    }

    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        if (!(annotatedObject instanceof Specification)) {
            reporter.reportProblem(annotation, "annotation may only be used on specifications.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
        if (!annotation.getArguments().isEmpty()) {
            reporter.reportProblem(annotation, "annotation has an argument.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
        long count = CifAnnotationUtils.getAnnotations((AnnotatedObject)spec, (String)this.annotationName).count();
        if (count > 1L) {
            reporter.reportProblem(this.annotationName, Strings.fmt((String)"the specification has more than one \"%s\" annotation, namely %d.", (Object[])new Object[]{this.annotationName, count}), spec.getPosition(), SemanticProblemSeverity.WARNING);
        }
    }
}

