/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.ExponentialDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class GammaDistribution
extends DoubleDistribution {
    private RandomGenerator randGen1;
    private RandomGenerator randGen2;
    private double shape;
    private double scale;

    public GammaDistribution(ChiCoordinator chiCoordinator, double shape, double scale) {
        super(chiCoordinator);
        if (shape <= 0.0) {
            String msg = Strings.fmt((String)"The Gamma distribution expects the shape parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{shape});
            throw new ChiSimulatorException(msg);
        }
        if (scale <= 0.0) {
            String msg = Strings.fmt((String)"The Gamma distribution expects the scale parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{scale});
            throw new ChiSimulatorException(msg);
        }
        this.shape = shape;
        this.scale = scale;
        this.randGen1 = chiCoordinator.getFreshGenerator();
        this.randGen2 = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return GammaDistribution.drawGamma(this.randGen1, this.randGen2, this.shape, this.scale);
    }

    public static double drawGamma(RandomGenerator randGen1, RandomGenerator randGen2, double shape, double scale) {
        double y;
        double z;
        double w;
        if (shape < 1.0) {
            double y2;
            double v;
            double w2;
            double beta = (Math.E + shape) / Math.E;
            do {
                w2 = beta * randGen1.draw();
                v = randGen2.draw();
            } while (!(w2 < 1.0 ? v <= Math.exp(-(y2 = Math.pow(w2, 1.0 / shape))) : v <= Math.pow(y2 = -Math.log((beta - w2) / shape), shape - 1.0)));
            return scale * y2;
        }
        if (shape == 1.0) {
            return ExponentialDistribution.drawExponential(randGen1, scale);
        }
        double alpha = 1.0 / Math.sqrt(2.0 * shape - 1.0);
        double beta = shape - Math.log(4.0);
        double gamma = shape + 1.0 / alpha;
        double delta = 1.0 + Math.log(4.5);
        do {
            double u1;
            double v;
            if (!((w = beta + gamma * (v = alpha * Math.log((u1 = randGen1.drawNonzero()) / (1.0 - u1))) - (y = shape * Math.exp(v))) + delta - 4.5 * (z = u1 * u1 * randGen2.drawNonzero()) >= 0.0)) continue;
            return scale * y;
        } while (!(w >= Math.log(z)));
        return scale * y;
    }
}

