/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.multivaluetrees;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.multivaluetrees.VarInfo;

public class VariableReplacement
implements Comparable<VariableReplacement> {
    public final VarInfo oldVar;
    public final VarInfo newVar;
    public final int topLevel;

    public VariableReplacement(VarInfo oldVar, VarInfo newVar) {
        Assert.check((oldVar.length == newVar.length ? 1 : 0) != 0);
        this.oldVar = oldVar;
        this.newVar = newVar;
        this.topLevel = Math.min(oldVar.level, newVar.level);
        int otherLevel = Math.max(oldVar.level, newVar.level);
        Assert.check((this.topLevel + 1 == otherLevel ? 1 : 0) != 0);
    }

    public boolean isOldAtTop() {
        return this.topLevel == this.oldVar.level;
    }

    @Override
    public int compareTo(VariableReplacement other) {
        if (this.oldVar.level > other.oldVar.level) {
            return 1;
        }
        if (this.oldVar.level < other.oldVar.level) {
            return -1;
        }
        if (this.newVar.level > other.newVar.level) {
            return 1;
        }
        if (this.newVar.level < other.newVar.level) {
            return -1;
        }
        return 0;
    }
}

