/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.javacompiler.JavaCompilerName;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class JavaCompilerOption
extends EnumOption<JavaCompilerName> {
    public JavaCompilerOption() {
        super("Java compiler", "The Java compiler implementation to use. Specify \"jdk\" to use the Java compiler provided by the Java Development Kit (requires the use of a JDK, a JRE is not sufficient), or \"eclipse\" to use the Eclipse Compiler for Java (ecj) which is part of the Eclipse Java Development Tools (JDT). [DEFAULT=jdk].", null, "java-compiler", "JCOMPILER", JavaCompilerName.JDK, true, "The Java compiler implementation to use.");
    }

    @Override
    protected String getDialogText(JavaCompilerName value) {
        switch (value) {
            case JDK: {
                return "Java compiler from the Java Development Kit (requires a JDK, a JRE is not sufficient)";
            }
            case ECLIPSE: {
                return "Eclipse Compiler for Java (ecj), part of the Eclipse Java Development Tools (JDT)";
            }
        }
        throw new RuntimeException("Unknown value: " + String.valueOf((Object)value));
    }

    public static String getCompilerName() {
        String name = ((JavaCompilerName)((Object)Options.get(JavaCompilerOption.class))).name();
        return name.toLowerCase(Locale.US);
    }
}

