/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class SingleRepositoryTracker
extends RepositoryTracker {
    private final ProvisioningUI ui;
    private final int repositoryType;
    private final Class<? extends IRepositoryManager<?>> repositoryManagerType;

    public static RepositoryTracker createMetadataRepositoryTracker(ProvisioningUI ui) {
        return new SingleRepositoryTracker(ui, 0, IMetadataRepositoryManager.class);
    }

    public static RepositoryTracker createArtifactRepositoryTracker(ProvisioningUI ui) {
        return new SingleRepositoryTracker(ui, 1, IArtifactRepositoryManager.class);
    }

    private SingleRepositoryTracker(ProvisioningUI ui, int repositoryType, Class<? extends IRepositoryManager<?>> repositoryManagerType) {
        this.ui = ui;
        this.repositoryType = repositoryType;
        this.repositoryManagerType = repositoryManagerType;
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return this.getRepositoryManager().getKnownRepositories(this.getArtifactRepositoryFlags());
    }

    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                this.getRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, this.repositoryType, 0, true), true);
        }
    }

    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            URI[] uRIArray = repoLocations;
            int n = repoLocations.length;
            int n2 = 0;
            while (n2 < n) {
                URI repoLocation = uRIArray[n2];
                this.getRepositoryManager().removeRepository(repoLocation);
                ++n2;
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(null, true);
        }
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        URI[] uRIArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            try {
                this.getRepositoryManager().refreshRepository(location, (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            ++n2;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    private IRepositoryManager<?> getRepositoryManager() {
        return (IRepositoryManager)this.ui.getSession().getProvisioningAgent().getService(this.repositoryManagerType);
    }

    protected boolean contains(URI location, ProvisioningSession session) {
        return ((IRepositoryManager)session.getProvisioningAgent().getService(this.repositoryManagerType)).contains(location);
    }
}

