/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderOp;
import org.apache.jena.sparql.sse.builders.SSE_BuildException;
import org.apache.jena.sparql.util.QueryExecUtils;

public class BuilderExec {
    public static void exec(Item item) {
        if (item.isNode()) {
            BuilderLib.broken(item, "Attempt to build evaluation from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build evaluation from a bare symbol");
        }
        if (!item.isTagged("exec")) {
            throw new SSE_BuildException("Wanted (exec...) : got: " + item.shortString());
        }
        ItemList list = item.getList();
        BuilderLib.checkLength(3, list, item.shortString() + " does not have 2 components");
        DatasetGraph dsg = BuilderGraph.buildDataset(list.get(1));
        Op op = BuilderOp.build(list.get(2));
        QueryExecUtils.execute(op, dsg, ResultsFormat.FMT_TEXT);
    }
}

