/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public abstract class SimulinkElement
extends SimulinkModelElement {
    protected static final String ADD_BLOCK_MAKE_NAME_UNIQUE_ON = "add_block('?', '?', 'MakeNameUnique', 'on');";
    protected static final String HANDLE = "handle = ?;";
    protected static final String GET_SIMULINK_KIND = "get_param(handle, 'Type');";
    protected static final String GET_SIMULINK_TYPE = "get_param(handle, '%sType');";
    protected static final String GET_FULL_NAME = "getfullname(?);";
    protected static final String GET_HANDLE_PROPERTY = "get_param(handle, '?');";
    protected Double handle = null;

    public SimulinkElement(SimulinkModel model, MatlabEngine engine, String type) throws MatlabRuntimeException {
        super((IGenericSimulinkModel)model, engine);
        try {
            String path = SimulinkUtil.getTypePathInModel(model, type);
            this.handle = (Double)engine.evalWithResult(ADD_BLOCK_MAKE_NAME_UNIQUE_ON, new Object[]{type, path});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatlabRuntimeException("Unable to create block element");
        }
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(SimulinkModel model, MatlabEngine engine, Double handle) throws MatlabRuntimeException {
        super((IGenericSimulinkModel)model, engine);
        if (handle == -1.0) {
            throw new MatlabRuntimeException("Bad handle -1");
        }
        this.handle = handle;
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(String path, SimulinkModel model, MatlabEngine engine) throws MatlabRuntimeException {
        super((IGenericSimulinkModel)model, engine);
        this.setHandle(path);
        try {
            this.setType();
        }
        catch (MatlabException matlabException) {
            throw new MatlabRuntimeException("Unable to set up the type");
        }
    }

    public SimulinkElement(SimulinkModel model, MatlabEngine engine) {
        super((IGenericSimulinkModel)model, engine);
    }

    public Object getProperty(String property) throws EolRuntimeException {
        try {
            String command = "handle = ?; property = '?';try\n        result = get_param(handle,property);\n    catch ME\n        if contains(ME.message, '(mask)');\n            maskParams = get_param(handle,'MaskPrompts');\n            [tf,idx] = ismember(maskParams,property);\n            idx = find(idx==1);\n            maskVal = get_param(handle,'MaskValues');\n            result = maskVal{idx};\n        end\n    end";
            this.engine.eval(command, new Object[]{this.getHandle(), property});
            return this.engine.getVariable("result");
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        try {
            String escaped = "?";
            if (value instanceof ISimulinkModelElement) {
                ISimulinkModelElement element = (ISimulinkModelElement)value;
                value = element.getHandle();
            } else {
                escaped = "'" + escaped + "'";
            }
            String stringValue = String.valueOf(value);
            String command = "handle = ?; property = '?';value = " + escaped + ";" + "stringValue = '?';" + "try\n" + "        set_param(handle,property,value);\n" + "    catch ME\n" + "        if contains(ME.message, '(mask)')\n" + "            maskParams = get_param(handle,'MaskPrompts');\n" + "            [tf,idx] = ismember(maskParams,property);\n" + "            idx = find(idx==1);\n" + "            maskVal = get_param(handle,'MaskValues');\n" + "            maskVal{idx} = char(stringValue);\n" + "            set_param(handle,'MaskValues',maskVal);\n" + "        end\n" + "    end";
            this.engine.eval(command, new Object[]{this.getHandle(), property, value, stringValue});
        }
        catch (MatlabException ex) {
            throw ex.toEolRuntimeException();
        }
    }

    public Object getHandle() {
        return this.handle;
    }

    private void setHandle(String path) {
        this.handle = SimulinkUtil.getHandle(path, this.engine);
    }

    private void setType() throws MatlabException {
        if (this.handle != null) {
            this.superType = (String)this.engine.evalWithSetupAndResult(HANDLE, GET_SIMULINK_KIND, new Object[]{this.handle});
            this.superType = StringUtil.firstToUpper((String)this.superType);
            String typeCmd = String.format(GET_SIMULINK_TYPE, this.superType);
            this.type = (String)this.engine.evalWithSetupAndResult(HANDLE, typeCmd, new Object[]{this.handle});
            try {
                TypeHelper.put(this.type, this.superType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getPath() {
        try {
            String path = (String)this.engine.evalWithResult(GET_FULL_NAME, new Object[]{this.handle});
            return path.replace("\n", " ");
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    public boolean equals(Object other) {
        return other instanceof SimulinkElement && ((SimulinkElement)((Object)other)).getHandle().equals(this.getHandle());
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(TypeHelper.Kind.SIMULINK.getKind(), this.getType(), this.getSuperType());
    }

    public String toString() {
        return String.valueOf(this.getType()) + "[ Path=" + this.getPath() + ", handle=" + this.getHandle() + "]";
    }
}

