/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.FeatureMapEntry;
import org.eclipse.emf.ecore.change.impl.FeatureMapEntryImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.StructuralFeatureMutation;
import org.eclipse.emf.emfstore.modelmutator.ESFeatureMapValueMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapValueMutation
extends StructuralFeatureMutation<ESFeatureMapValueMutation>
implements ESFeatureMapValueMutation {
    public FeatureMapValueMutation(ESModelMutatorUtil util) {
        super(util);
        this.addTargetFeaturePredicate();
        this.addOriginalFeatureValuePredicate();
    }

    public FeatureMapValueMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addTargetFeaturePredicate();
        this.addOriginalFeatureValuePredicate();
    }

    private void addTargetFeaturePredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.HAS_GROUP_FEATURE_MAP_ENTRY_TYPE);
    }

    private void addOriginalFeatureValuePredicate() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_FEATURE_MAP);
    }

    @Override
    public Mutation clone() {
        return new FeatureMapValueMutation(this.getUtil(), this.getTargetContainerSelector());
    }

    @Override
    public void apply() throws ESMutationException {
        this.getTargetContainerSelector().doSelection();
        List<FeatureMap.Entry> currentEntries = this.getFeatureMapEntries();
        FeatureMap.Entry entry = this.getRandomFeatureMapEntryOfTarget(currentEntries);
        EStructuralFeature currentFeatureKey = entry.getEStructuralFeature();
        if (FeatureMapValueMutation.isReference(currentFeatureKey) && !FeatureMapValueMutation.isContainmentReference(currentFeatureKey)) {
            EObject currentValue = (EObject)EObject.class.cast(entry.getValue());
            EObject selectedEObject = this.selectEObject(currentValue.eClass());
            if (selectedEObject != null) {
                FeatureMap.Entry.Internal createEntry;
                if (FeatureMapEntry.class.isInstance(entry)) {
                    ((FeatureMapEntry)FeatureMapEntry.class.cast(entry)).setReferenceValue(selectedEObject);
                } else if (EStructuralFeatureImpl.SimpleFeatureMapEntry.class.isInstance(entry) && !currentEntries.contains(createEntry = ((EStructuralFeatureImpl.SimpleFeatureMapEntry)entry).createEntry((Object)selectedEObject))) {
                    currentEntries.set(currentEntries.indexOf(entry), (FeatureMap.Entry)createEntry);
                }
            }
        } else if (FeatureMapValueMutation.isContainmentReference(currentFeatureKey)) {
            if (FeatureMapEntryImpl.class.isInstance(entry)) {
                FeatureMapEntryImpl featureMapEntry = (FeatureMapEntryImpl)FeatureMapEntryImpl.class.cast(entry);
                featureMapEntry.setReferenceValue(this.createOfType(((EReference)EReference.class.cast(featureMapEntry.getEStructuralFeature())).getEReferenceType()));
            }
        } else if (!EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry.class.isInstance(entry)) {
            EAttribute.class.isInstance(currentFeatureKey);
        }
    }

    public EObject createOfType(EClass eClass) {
        EObject eObjectToAdd = EcoreUtil.create((EClass)eClass);
        this.getUtil().setEObjectAttributes(eObjectToAdd);
        return eObjectToAdd;
    }

    private EObject selectEObject(EClass eClass) {
        Map<EClass, List<EObject>> allObjects = ESModelMutatorUtil.getAllObjects(this.getUtil().getModelMutatorConfiguration().getRootEObject());
        List<EObject> possibleObjects = allObjects.get(eClass);
        EObject selectedEObject = null;
        if (possibleObjects != null && !possibleObjects.isEmpty()) {
            while (!possibleObjects.isEmpty() && selectedEObject == null) {
                selectedEObject = possibleObjects.get(this.getRandom().nextInt(possibleObjects.size()));
                if (this.eObjectFits(selectedEObject)) continue;
                possibleObjects.remove(selectedEObject);
                selectedEObject = null;
            }
        }
        return selectedEObject;
    }

    private boolean eObjectFits(EObject eObject) {
        EClass eClass = eObject.eClass();
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : eAllStructuralFeatures) {
            if (!feature.getEType().equals(EcorePackage.eINSTANCE.getEFeatureMap())) continue;
            return false;
        }
        return true;
    }

    private static boolean isReference(EStructuralFeature feature) {
        return EReference.class.isInstance(feature);
    }

    private static boolean isContainmentReference(EStructuralFeature feature) {
        return EReference.class.isInstance(feature) && ((EReference)EReference.class.cast(feature)).isContainment();
    }

    private List<FeatureMap.Entry> getFeatureMapEntries() {
        return (List)this.getTargetObject().eGet(this.getTargetFeature());
    }

    private FeatureMap.Entry getRandomFeatureMapEntryOfTarget(List<FeatureMap.Entry> currentEntries) {
        int pickIndex = this.getRandom().nextInt(currentEntries.size());
        return currentEntries.get(pickIndex);
    }
}

